/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BiomeDictionary {
    private static final boolean DEBUG = false;
    private static final Map<nf, BiomeInfo> biomeInfoMap = new HashMap<nf, BiomeInfo>();

    public static void addTypes(anh biome, Type ... types) {
        Preconditions.checkArgument((boolean)ForgeRegistries.BIOMES.containsValue(biome), (String)"Cannot add types to unregistered biome %s", (Object)biome);
        Collection<Type> supertypes = BiomeDictionary.listSupertypes(types);
        Collections.addAll(supertypes, types);
        for (Type type : supertypes) {
            type.biomes.add(biome);
        }
        BiomeInfo biomeInfo = BiomeDictionary.getBiomeInfo(biome);
        Collections.addAll(biomeInfo.types, types);
        biomeInfo.types.addAll(supertypes);
    }

    @Nonnull
    public static Set<anh> getBiomes(Type type) {
        return type.biomesUn;
    }

    @Nonnull
    public static Set<Type> getTypes(anh biome) {
        BiomeDictionary.ensureHasTypes(biome);
        return BiomeDictionary.getBiomeInfo(biome).typesUn;
    }

    public static boolean areSimilar(anh biomeA, anh biomeB) {
        for (Type type : BiomeDictionary.getTypes(biomeA)) {
            if (!BiomeDictionary.getTypes(biomeB).contains(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasType(anh biome, Type type) {
        return BiomeDictionary.getTypes(biome).contains(type);
    }

    public static boolean hasAnyType(anh biome) {
        return !BiomeDictionary.getBiomeInfo(biome).types.isEmpty();
    }

    public static void makeBestGuess(anh biome) {
        if (biome.s.z >= 3) {
            if (biome.e() && biome.n() >= 0.9f) {
                BiomeDictionary.addTypes(biome, Type.JUNGLE);
            } else if (!biome.e()) {
                BiomeDictionary.addTypes(biome, Type.FOREST);
                if (biome.n() <= 0.2f) {
                    BiomeDictionary.addTypes(biome, Type.CONIFEROUS);
                }
            }
        } else if (biome.m() <= 0.3f && biome.m() >= 0.0f && (!biome.e() || biome.j() >= 0.0f)) {
            BiomeDictionary.addTypes(biome, Type.PLAINS);
        }
        if (biome.k() > 0.85f) {
            BiomeDictionary.addTypes(biome, Type.WET);
        }
        if (biome.k() < 0.15f) {
            BiomeDictionary.addTypes(biome, Type.DRY);
        }
        if (biome.n() > 0.85f) {
            BiomeDictionary.addTypes(biome, Type.HOT);
        }
        if (biome.n() < 0.15f) {
            BiomeDictionary.addTypes(biome, Type.COLD);
        }
        if (biome.s.z > 0 && biome.s.z < 3) {
            BiomeDictionary.addTypes(biome, Type.SPARSE);
        } else if (biome.s.z >= 10) {
            BiomeDictionary.addTypes(biome, Type.DENSE);
        }
        if (biome.e() && biome.j() < 0.0f && biome.m() <= 0.3f && biome.m() >= 0.0f) {
            BiomeDictionary.addTypes(biome, Type.SWAMP);
        }
        if (biome.j() <= -0.5f) {
            if (biome.m() == 0.0f) {
                BiomeDictionary.addTypes(biome, Type.RIVER);
            } else {
                BiomeDictionary.addTypes(biome, Type.OCEAN);
            }
        }
        if (biome.m() >= 0.4f && biome.m() < 1.5f) {
            BiomeDictionary.addTypes(biome, Type.HILLS);
        }
        if (biome.m() >= 1.5f) {
            BiomeDictionary.addTypes(biome, Type.MOUNTAIN);
        }
        if (biome.c()) {
            BiomeDictionary.addTypes(biome, Type.SNOWY);
        }
        if (biome.q.u() != aox.m && biome.n() >= 1.0f && biome.k() < 0.2f) {
            BiomeDictionary.addTypes(biome, Type.SAVANNA);
        }
        if (biome.q.u() == aox.m) {
            BiomeDictionary.addTypes(biome, Type.SANDY);
        } else if (biome.q.u() == aox.bw) {
            BiomeDictionary.addTypes(biome, Type.MUSHROOM);
        }
        if (biome.r.u() == aox.cz) {
            BiomeDictionary.addTypes(biome, Type.MESA);
        }
    }

    private static BiomeInfo getBiomeInfo(anh biome) {
        return biomeInfoMap.computeIfAbsent(biome.getRegistryName(), k -> new BiomeInfo());
    }

    static void ensureHasTypes(anh biome) {
        if (!BiomeDictionary.hasAnyType(biome)) {
            BiomeDictionary.makeBestGuess(biome);
            FMLLog.log.warn("No types have been added to Biome {}, types have been assigned on a best-effort guess: {}", (Object)biome.getRegistryName(), !BiomeDictionary.getBiomeInfo(biome).types.isEmpty() ? BiomeDictionary.getBiomeInfo(biome).types : "could not guess types");
            if (Boolean.valueOf(false).booleanValue()) {
                BiomeDictionary.getTypes(biome);
            }
        }
    }

    private static Collection<Type> listSupertypes(Type ... types) {
        HashSet<Type> supertypes = new HashSet<Type>();
        ArrayDeque<Type> next = new ArrayDeque<Type>();
        Collections.addAll(next, types);
        while (!next.isEmpty()) {
            Type type = (Type)next.remove();
            for (Type sType : Type.byName.values()) {
                if (!sType.subTypes.contains(type) || !supertypes.add(sType)) continue;
                next.add(sType);
            }
        }
        return supertypes;
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.addTypes(anm.a, Type.OCEAN);
        BiomeDictionary.addTypes(anm.c, Type.PLAINS);
        BiomeDictionary.addTypes(anm.d, Type.HOT, Type.DRY, Type.SANDY);
        BiomeDictionary.addTypes(anm.e, Type.MOUNTAIN, Type.HILLS);
        BiomeDictionary.addTypes(anm.f, Type.FOREST);
        BiomeDictionary.addTypes(anm.g, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.addTypes(anm.h, Type.WET, Type.SWAMP);
        BiomeDictionary.addTypes(anm.i, Type.RIVER);
        BiomeDictionary.addTypes(anm.j, Type.HOT, Type.DRY, Type.NETHER);
        BiomeDictionary.addTypes(anm.k, Type.COLD, Type.DRY, Type.END);
        BiomeDictionary.addTypes(anm.l, Type.COLD, Type.OCEAN, Type.SNOWY);
        BiomeDictionary.addTypes(anm.m, Type.COLD, Type.RIVER, Type.SNOWY);
        BiomeDictionary.addTypes(anm.n, Type.COLD, Type.SNOWY, Type.WASTELAND);
        BiomeDictionary.addTypes(anm.o, Type.COLD, Type.SNOWY, Type.MOUNTAIN);
        BiomeDictionary.addTypes(anm.p, Type.MUSHROOM, Type.RARE);
        BiomeDictionary.addTypes(anm.q, Type.MUSHROOM, Type.BEACH, Type.RARE);
        BiomeDictionary.addTypes(anm.r, Type.BEACH);
        BiomeDictionary.addTypes(anm.s, Type.HOT, Type.DRY, Type.SANDY, Type.HILLS);
        BiomeDictionary.addTypes(anm.t, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(anm.u, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(anm.v, Type.MOUNTAIN);
        BiomeDictionary.addTypes(anm.w, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE);
        BiomeDictionary.addTypes(anm.x, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.HILLS);
        BiomeDictionary.addTypes(anm.y, Type.HOT, Type.WET, Type.JUNGLE, Type.FOREST, Type.RARE);
        BiomeDictionary.addTypes(anm.z, Type.OCEAN);
        BiomeDictionary.addTypes(anm.A, Type.BEACH);
        BiomeDictionary.addTypes(anm.B, Type.COLD, Type.BEACH, Type.SNOWY);
        BiomeDictionary.addTypes(anm.C, Type.FOREST);
        BiomeDictionary.addTypes(anm.D, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(anm.E, Type.SPOOKY, Type.DENSE, Type.FOREST);
        BiomeDictionary.addTypes(anm.F, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY);
        BiomeDictionary.addTypes(anm.G, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.HILLS);
        BiomeDictionary.addTypes(anm.H, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.addTypes(anm.I, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(anm.J, Type.MOUNTAIN, Type.FOREST, Type.SPARSE);
        BiomeDictionary.addTypes(anm.K, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE);
        BiomeDictionary.addTypes(anm.L, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE, Type.RARE);
        BiomeDictionary.addTypes(anm.M, Type.MESA, Type.SANDY, Type.DRY);
        BiomeDictionary.addTypes(anm.N, Type.MESA, Type.SANDY, Type.DRY, Type.SPARSE);
        BiomeDictionary.addTypes(anm.O, Type.MESA, Type.SANDY, Type.DRY);
        BiomeDictionary.addTypes(anm.P, Type.VOID);
        BiomeDictionary.addTypes(anm.Q, Type.PLAINS, Type.RARE);
        BiomeDictionary.addTypes(anm.R, Type.HOT, Type.DRY, Type.SANDY, Type.RARE);
        BiomeDictionary.addTypes(anm.S, Type.MOUNTAIN, Type.SPARSE, Type.RARE);
        BiomeDictionary.addTypes(anm.T, Type.FOREST, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(anm.U, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(anm.V, Type.WET, Type.SWAMP, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(anm.W, Type.COLD, Type.SNOWY, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(anm.X, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(anm.Y, Type.HOT, Type.SPARSE, Type.JUNGLE, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(anm.Z, Type.FOREST, Type.DENSE, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(anm.aa, Type.FOREST, Type.DENSE, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(anm.ab, Type.SPOOKY, Type.DENSE, Type.FOREST, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(anm.ac, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(anm.ad, Type.DENSE, Type.FOREST, Type.RARE);
        BiomeDictionary.addTypes(anm.ae, Type.DENSE, Type.FOREST, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(anm.af, Type.MOUNTAIN, Type.SPARSE, Type.RARE);
        BiomeDictionary.addTypes(anm.ag, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(anm.ah, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(anm.ai, Type.HOT, Type.DRY, Type.SPARSE, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(anm.aj, Type.HOT, Type.DRY, Type.SPARSE, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(anm.ak, Type.HOT, Type.DRY, Type.SPARSE, Type.MOUNTAIN, Type.RARE);
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    private static class BiomeInfo {
        private final Set<Type> types = new HashSet<Type>();
        private final Set<Type> typesUn = Collections.unmodifiableSet(this.types);

        private BiomeInfo() {
        }
    }

    public static final class Type {
        private static final Map<String, Type> byName = new HashMap<String, Type>();
        private static Collection<Type> allTypes = Collections.unmodifiableCollection(byName.values());
        public static final Type HOT = new Type("HOT", new Type[0]);
        public static final Type COLD = new Type("COLD", new Type[0]);
        public static final Type SPARSE = new Type("SPARSE", new Type[0]);
        public static final Type DENSE = new Type("DENSE", new Type[0]);
        public static final Type WET = new Type("WET", new Type[0]);
        public static final Type DRY = new Type("DRY", new Type[0]);
        public static final Type SAVANNA = new Type("SAVANNA", new Type[0]);
        public static final Type CONIFEROUS = new Type("CONIFEROUS", new Type[0]);
        public static final Type JUNGLE = new Type("JUNGLE", new Type[0]);
        public static final Type SPOOKY = new Type("SPOOKY", new Type[0]);
        public static final Type DEAD = new Type("DEAD", new Type[0]);
        public static final Type LUSH = new Type("LUSH", new Type[0]);
        public static final Type NETHER = new Type("NETHER", new Type[0]);
        public static final Type END = new Type("END", new Type[0]);
        public static final Type MUSHROOM = new Type("MUSHROOM", new Type[0]);
        public static final Type MAGICAL = new Type("MAGICAL", new Type[0]);
        public static final Type RARE = new Type("RARE", new Type[0]);
        public static final Type OCEAN = new Type("OCEAN", new Type[0]);
        public static final Type RIVER = new Type("RIVER", new Type[0]);
        public static final Type WATER = new Type("WATER", OCEAN, RIVER);
        public static final Type MESA = new Type("MESA", new Type[0]);
        public static final Type FOREST = new Type("FOREST", new Type[0]);
        public static final Type PLAINS = new Type("PLAINS", new Type[0]);
        public static final Type MOUNTAIN = new Type("MOUNTAIN", new Type[0]);
        public static final Type HILLS = new Type("HILLS", new Type[0]);
        public static final Type SWAMP = new Type("SWAMP", new Type[0]);
        public static final Type SANDY = new Type("SANDY", new Type[0]);
        public static final Type SNOWY = new Type("SNOWY", new Type[0]);
        public static final Type WASTELAND = new Type("WASTELAND", new Type[0]);
        public static final Type BEACH = new Type("BEACH", new Type[0]);
        public static final Type VOID = new Type("VOID", new Type[0]);
        private final String name;
        private final List<Type> subTypes;
        private final Set<anh> biomes = new HashSet<anh>();
        private final Set<anh> biomesUn = Collections.unmodifiableSet(this.biomes);

        private Type(String name, Type ... subTypes) {
            this.name = name;
            this.subTypes = ImmutableList.copyOf((Object[])subTypes);
            byName.put(name, this);
        }

        private boolean hasSubTypes() {
            return !this.subTypes.isEmpty();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Type getType(String name, Type ... subTypes) {
            Type t = byName.get(name = name.toUpperCase());
            if (t == null) {
                t = new Type(name, subTypes);
            }
            return t;
        }

        public static Collection<Type> getAll() {
            return allTypes;
        }
    }
}

