/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.internal;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.RecordEvent;
import net.minecraftforge.eventbus.api.listener.EventListener;
import net.minecraftforge.eventbus.internal.AbstractEventBusImpl;
import net.minecraftforge.eventbus.internal.CancellableEventBusImpl;
import net.minecraftforge.eventbus.internal.Constants;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.eventbus.internal.EventBusImpl;
import net.minecraftforge.eventbus.internal.EventListenerFactory;

public record BusGroupImpl(String name, Class<?> baseType, ConcurrentHashMap<Class<? extends Event>, EventBus<?>> eventBuses) implements BusGroup
{
    private static final Set<String> BUS_GROUP_NAMES = ConcurrentHashMap.newKeySet();

    public BusGroupImpl(String name, Class<?> baseType) {
        this(name, baseType, new ConcurrentHashMap());
    }

    public BusGroupImpl {
        if (!BUS_GROUP_NAMES.add(Objects.requireNonNull(name))) {
            throw new IllegalArgumentException("BusGroup name \"" + name + "\" is already in use");
        }
    }

    @Override
    public void startup() {
        for (EventBus<?> eventBus : this.eventBuses.values()) {
            ((AbstractEventBusImpl)eventBus).startup();
        }
    }

    @Override
    public void shutdown() {
        for (EventBus<?> eventBus : this.eventBuses.values()) {
            ((AbstractEventBusImpl)eventBus).shutdown();
        }
    }

    @Override
    public void dispose() {
        for (EventBus<?> eventBus : this.eventBuses.values()) {
            ((AbstractEventBusImpl)eventBus).dispose();
        }
        this.eventBuses.clear();
        BUS_GROUP_NAMES.remove(this.name);
    }

    @Override
    public void trim() {
        for (EventBus<?> eventBus : this.eventBuses.values()) {
            ((AbstractEventBusImpl)eventBus).trim();
        }
    }

    @Override
    public Collection<EventListener> register(MethodHandles.Lookup callerLookup, Class<?> utilityClassWithStaticListeners) {
        return Constants.STRICT_REGISTRATION_CHECKS ? EventListenerFactory.registerStrict(this, callerLookup, utilityClassWithStaticListeners, null) : EventListenerFactory.register(this, callerLookup, utilityClassWithStaticListeners, null);
    }

    @Override
    public Collection<EventListener> register(MethodHandles.Lookup callerLookup, Object listener) {
        return Constants.STRICT_REGISTRATION_CHECKS ? EventListenerFactory.registerStrict(this, callerLookup, listener.getClass(), listener) : EventListenerFactory.register(this, callerLookup, listener.getClass(), listener);
    }

    @Override
    public void unregister(Collection<EventListener> listeners) {
        if (listeners.isEmpty()) {
            throw new IllegalArgumentException("Listeners cannot be empty! You should be getting the collection fromthe BusGroup#register method.");
        }
        for (EventListener listener : listeners) {
            this.getOrCreateEventBus(listener.eventType()).removeListener(listener);
        }
    }

    private <T extends Event> EventBus<T> createEventBus(Class<T> eventType) {
        Record bus;
        if (this.baseType != Event.class && !this.baseType.isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("BusGroup \"" + this.name + "\" requires all events on it to inherit from " + String.valueOf(this.baseType) + " but " + String.valueOf(eventType) + " doesn't.");
        }
        if (RecordEvent.class.isAssignableFrom(eventType) && !eventType.isRecord()) {
            throw new IllegalArgumentException("Event type " + String.valueOf(eventType) + " is not a record class but implements RecordEvent");
        }
        int characteristics = AbstractEventBusImpl.computeEventCharacteristics(eventType);
        if (Constants.isMonitorAware(characteristics) && !MutableEvent.class.isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("Event type " + String.valueOf(eventType) + " implements MonitorAware but is not a MutableEvent");
        }
        ArrayList<EventListener> backingList = new ArrayList<EventListener>();
        List<Object> parents = Collections.emptyList();
        if (Constants.isInheritable(characteristics)) {
            parents = this.getParentEvents(eventType);
            for (EventBus eventBus : parents) {
                backingList.addAll(((AbstractEventBusImpl)eventBus).backingList());
            }
        }
        Record record = bus = Constants.isCancellable(characteristics) ? new CancellableEventBusImpl<T>(this.name, eventType, backingList, characteristics) : new EventBusImpl<T>(this.name, eventType, backingList, characteristics);
        if (Constants.isInheritable(characteristics)) {
            for (EventBus eventBus : parents) {
                ((AbstractEventBusImpl)eventBus).children().add((AbstractEventBusImpl)((Object)bus));
            }
        }
        return bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Event> EventBus<T> getOrCreateEventBus(Class<T> eventType) {
        EventBus<?> eventBus = this.eventBuses.get(eventType);
        if (eventBus != null) {
            return eventBus;
        }
        EventBus<T> computedEventBus = this.createEventBus(eventType);
        ConcurrentHashMap<Class<? extends Event>, EventBus<?>> concurrentHashMap = this.eventBuses;
        synchronized (concurrentHashMap) {
            EventBus<T> existing = this.eventBuses.putIfAbsent(eventType, computedEventBus);
            return existing == null ? computedEventBus : existing;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object that) {
        if (this == that) return true;
        if (!(that instanceof BusGroupImpl)) return false;
        BusGroupImpl busGroup = (BusGroupImpl)that;
        if (!this.name.equals(busGroup.name)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    private <T extends Event> List<EventBus<?>> getParentEvents(Class<T> eventType) {
        ArrayList parentEvents = new ArrayList();
        Class<T> parent = eventType.getSuperclass();
        if (parent != null && InheritableEvent.class.isAssignableFrom(parent) && parent != MutableEvent.class) {
            EventBus<T> parentEvent = this.getOrCreateEventBus(parent);
            parentEvents.add(parentEvent);
        }
        for (Class<?> iface : eventType.getInterfaces()) {
            if (iface == InheritableEvent.class || !InheritableEvent.class.isAssignableFrom(iface) || iface == RecordEvent.class || iface == Event.class) continue;
            EventBus<?> parentEvent = this.getOrCreateEventBus(iface);
            parentEvents.add(parentEvent);
        }
        return parentEvents;
    }
}

