/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.internal;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import net.minecraftforge.eventbus.api.listener.EventListener;
import net.minecraftforge.eventbus.api.listener.ObjBooleanBiConsumer;
import net.minecraftforge.eventbus.internal.Event;

public sealed interface EventListenerImpl
extends EventListener {

    public record WrappedConsumerListener<T extends Event>(Class<T> eventType, byte priority, boolean alwaysCancelling, Consumer<T> consumer, Predicate<T> predicate) implements HasConsumer<T>,
    HasPredicate<T>
    {
        public WrappedConsumerListener(Class<T> eventType, byte priority, Consumer<T> consumer) {
            this(eventType, priority, false, consumer, WrappedConsumerListener.wrap(false, consumer));
        }

        public WrappedConsumerListener(Class<T> eventType, byte priority, boolean alwaysCancelling, Consumer<T> consumer) {
            this(eventType, priority, alwaysCancelling, consumer, WrappedConsumerListener.wrap(alwaysCancelling, consumer));
        }

        public WrappedConsumerListener {
            assert (!alwaysCancelling || priority != -128) : "Monitoring listeners cannot cancel events";
        }

        public static <T extends Event> Predicate<T> wrap(boolean alwaysCancelling, Consumer<T> consumer) {
            if (alwaysCancelling) {
                return event -> {
                    consumer.accept(event);
                    return true;
                };
            }
            return event -> {
                consumer.accept(event);
                return false;
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof WrappedConsumerListener)) return false;
            WrappedConsumerListener that = (WrappedConsumerListener)obj;
            if (this.eventType != that.eventType) return false;
            if (this.priority != that.priority) return false;
            if (this.alwaysCancelling != that.alwaysCancelling) return false;
            if (!this.consumer.equals(that.consumer)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.eventType.hashCode() * 31 + this.priority * 31 + Boolean.hashCode(this.alwaysCancelling) * 31 + this.consumer.hashCode();
        }
    }

    public record MonitoringListener<T extends Event>(Class<T> eventType, ObjBooleanBiConsumer<T> booleanBiConsumer) implements EventListenerImpl
    {
        public MonitoringListener(Class<T> eventType, Consumer<T> listener) {
            this(eventType, (T event, boolean wasCancelled) -> listener.accept(event));
        }

        @Override
        public byte priority() {
            return -128;
        }
    }

    public record PredicateListener<T extends Event & Cancellable>(Class<T> eventType, byte priority, Predicate<T> predicate) implements HasPredicate<T>
    {
        public PredicateListener {
            assert (priority != -128) : "Monitoring listeners cannot cancel events";
        }
    }

    public record ConsumerListener<T extends Event>(Class<T> eventType, byte priority, Consumer<T> consumer) implements HasConsumer<T>
    {
    }

    public static sealed interface HasPredicate<T extends Event>
    extends EventListenerImpl
    permits PredicateListener, WrappedConsumerListener {
        public Predicate<T> predicate();
    }

    public static sealed interface HasConsumer<T extends Event>
    extends EventListenerImpl
    permits ConsumerListener, WrappedConsumerListener {
        public Consumer<T> consumer();
    }
}

