/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.internal;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VolatileCallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.listener.EventListener;
import net.minecraftforge.eventbus.internal.AbstractEventBusImpl;
import net.minecraftforge.eventbus.internal.Constants;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.eventbus.internal.EventListenerImpl;
import net.minecraftforge.eventbus.internal.InvokerFactory;
import org.jspecify.annotations.Nullable;

public record EventBusImpl<T extends Event>(String busGroupName, Class<T> eventType, CallSite invokerCallSite, ArrayList<EventListener> backingList, ArrayList<EventListener> monitorBackingList, List<AbstractEventBusImpl<?, ?>> children, AtomicBoolean alreadyInvalidated, AtomicBoolean shutdownFlag, int eventCharacteristics) implements EventBus<T>,
AbstractEventBusImpl<T, Consumer<T>>
{
    public EventBusImpl(String busGroupName, Class<T> eventType, ArrayList<EventListener> backingList, int eventCharacteristics) {
        this(busGroupName, eventType, new VolatileCallSite(backingList.isEmpty() ? Constants.MH_NO_OP_CONSUMER : Constants.MH_NULL_CONSUMER), backingList, new ArrayList<EventListener>(), AbstractEventBusImpl.makeEventChildrenList(eventType, eventCharacteristics), new AtomicBoolean(), new AtomicBoolean(), eventCharacteristics);
    }

    @Override
    public EventListener addListener(Consumer<T> listener) {
        return this.addListener(new EventListenerImpl.ConsumerListener<T>(this.eventType, 0, listener));
    }

    @Override
    public EventListener addListener(byte priority, Consumer<T> listener) {
        return this.addListener((EventListener)((Object)(priority == -128 ? new EventListenerImpl.MonitoringListener<T>(this.eventType, listener) : new EventListenerImpl.ConsumerListener<T>(this.eventType, priority, listener))));
    }

    @Override
    public boolean post(T event) {
        ((Consumer)this.getInvoker()).accept(event);
        return false;
    }

    @Override
    public T fire(T event) {
        ((Consumer)this.getInvoker()).accept(event);
        return event;
    }

    @Override
    public boolean hasListeners() {
        return this.getInvoker() != Constants.NO_OP_CONSUMER;
    }

    @Override
    public @Nullable Consumer<T> maybeGetInvoker() {
        try {
            return this.invokerCallSite.getTarget().invokeExact();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void invalidateInvoker() {
        this.invokerCallSite.setTarget(this.backingList.isEmpty() ? Constants.MH_NO_OP_CONSUMER : Constants.MH_NULL_CONSUMER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer<T> buildInvoker() {
        ArrayList<EventListener> arrayList = this.backingList;
        synchronized (arrayList) {
            this.backingList.sort(Constants.PRIORITY_COMPARATOR);
            Consumer<Event> invoker = InvokerFactory.createMonitoringInvoker(this.eventType, this.eventCharacteristics, this.backingList, this.monitorBackingList);
            if (Constants.isSelfDestructing(this.eventCharacteristics)) {
                invoker = invoker.andThen(event -> this.dispose());
            }
            this.setInvoker(invoker);
            this.alreadyInvalidated.set(false);
            return invoker;
        }
    }

    @Override
    public void setNoOpInvoker() {
        this.invokerCallSite.setTarget(Constants.MH_NO_OP_CONSUMER);
    }

    private void setInvoker(Consumer<T> invoker) {
        this.invokerCallSite.setTarget(MethodHandles.constant(Consumer.class, invoker));
    }
}

