/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import net.minecraftforge.eventbus.api.listener.EventListener;
import net.minecraftforge.eventbus.api.listener.ObjBooleanBiConsumer;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.eventbus.internal.EventListenerImpl;

final class InvokerFactoryUtils {
    private InvokerFactoryUtils() {
    }

    static <T extends Event> List<Consumer<T>> unwrapConsumers(List<EventListener> listeners) {
        return listeners.stream().map(listener -> {
            if (listener instanceof EventListenerImpl.HasConsumer) {
                EventListenerImpl.HasConsumer consumerListener = (EventListenerImpl.HasConsumer)listener;
                return consumerListener.consumer();
            }
            throw new IllegalStateException("Unexpected listener type: " + String.valueOf(listener.getClass()));
        }).map(InvokerFactoryUtils::uncheckedCast).toList();
    }

    static <T extends Event> List<Consumer<T>> unwrapAlwaysCancellingConsumers(List<EventListener> listeners) {
        ArrayList<Consumer<T>> unwrappedConsumers = new ArrayList<Consumer<T>>(listeners.size());
        for (EventListener listener : listeners) {
            EventListenerImpl.WrappedConsumerListener wrappedConsumerListener;
            if (!(listener instanceof EventListenerImpl.HasConsumer)) {
                throw new IllegalStateException("Unexpected listener type: " + String.valueOf(listener.getClass()));
            }
            EventListenerImpl.HasConsumer consumerListener = (EventListenerImpl.HasConsumer)listener;
            unwrappedConsumers.add((Consumer)InvokerFactoryUtils.uncheckedCast(consumerListener.consumer()));
            if (!(listener instanceof EventListenerImpl.WrappedConsumerListener) || !(wrappedConsumerListener = (EventListenerImpl.WrappedConsumerListener)listener).alwaysCancelling()) continue;
            unwrappedConsumers.trimToSize();
            break;
        }
        return unwrappedConsumers;
    }

    static <T extends Event & Cancellable> List<Predicate<T>> unwrapPredicates(List<EventListener> listeners) {
        ArrayList<Predicate<T>> unwrappedPredicates = new ArrayList<Predicate<T>>(listeners.size());
        for (EventListener listener : listeners) {
            EventListenerImpl.WrappedConsumerListener wrappedConsumerListener;
            if (listener instanceof EventListenerImpl.HasPredicate) {
                EventListenerImpl.HasPredicate predicateListener = (EventListenerImpl.HasPredicate)listener;
                unwrappedPredicates.add((Predicate)InvokerFactoryUtils.uncheckedCast(predicateListener.predicate()));
            } else if (listener instanceof EventListenerImpl.ConsumerListener) {
                EventListenerImpl.ConsumerListener consumerListener = (EventListenerImpl.ConsumerListener)listener;
                unwrappedPredicates.add((Predicate)InvokerFactoryUtils.uncheckedCast(EventListenerImpl.WrappedConsumerListener.wrap(false, consumerListener.consumer())));
            } else {
                throw new IllegalStateException("Unexpected listener type: " + String.valueOf(listener.getClass()));
            }
            if (!(listener instanceof EventListenerImpl.WrappedConsumerListener) || !(wrappedConsumerListener = (EventListenerImpl.WrappedConsumerListener)listener).alwaysCancelling()) continue;
            unwrappedPredicates.trimToSize();
            break;
        }
        return unwrappedPredicates;
    }

    static <T extends Event> List<ObjBooleanBiConsumer<T>> unwrapMonitors(List<EventListener> monitoringListeners) {
        return monitoringListeners.stream().map(EventListenerImpl.MonitoringListener.class::cast).map(EventListenerImpl.MonitoringListener::booleanBiConsumer).toList();
    }

    private static <T> T uncheckedCast(Object obj) {
        return (T)obj;
    }
}

