/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.internal;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import net.minecraftforge.eventbus.api.listener.EventListener;
import net.minecraftforge.eventbus.api.listener.ObjBooleanBiConsumer;
import net.minecraftforge.eventbus.internal.Constants;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.eventbus.internal.EventListenerImpl;
import net.minecraftforge.eventbus.internal.InvokerFactoryUtils;
import net.minecraftforge.eventbus.internal.MutableEventInternals;

final class InvokerFactory {
    private static final int UNWRAP_CANCELLABLE_THRESHOLD = Integer.getInteger("eventbus.experimental.unwrapCancellableThreshold", 4);

    private InvokerFactory() {
    }

    static <T extends Event> Consumer<T> createMonitoringInvoker(Class<T> eventType, int eventCharacteristics, List<EventListener> listeners, List<EventListener> monitoringListeners) {
        Consumer invoker = InvokerFactory.createInvoker(listeners);
        if (monitoringListeners.isEmpty()) {
            return invoker;
        }
        List<ObjBooleanBiConsumer<ObjBooleanBiConsumer>> unwrappedMonitors = InvokerFactoryUtils.unwrapMonitors(monitoringListeners);
        if (Constants.isMonitorAware(eventCharacteristics)) {
            if (!MutableEvent.class.isAssignableFrom(eventType)) {
                throw new UnsupportedOperationException("This version of EventBus only supports EventCharacteristics.MonitorAware on MutableEvent");
            }
            if (monitoringListeners.size() == 1) {
                ObjBooleanBiConsumer firstMonitor = unwrappedMonitors.getFirst();
                return event -> {
                    invoker.accept(event);
                    MutableEventInternals mutableEvent = (MutableEventInternals)((Object)event);
                    mutableEvent.isMonitoring = true;
                    firstMonitor.accept(event, false);
                    mutableEvent.isMonitoring = false;
                };
            }
            ObjBooleanBiConsumer[] unwrappedMonitorsArray = unwrappedMonitors.toArray(new ObjBooleanBiConsumer[0]);
            return event -> {
                invoker.accept(event);
                MutableEventInternals mutableEvent = (MutableEventInternals)((Object)event);
                mutableEvent.isMonitoring = true;
                for (ObjBooleanBiConsumer monitor : unwrappedMonitorsArray) {
                    monitor.accept(event, false);
                }
                mutableEvent.isMonitoring = false;
            };
        }
        if (monitoringListeners.size() == 1) {
            ObjBooleanBiConsumer firstMonitor = unwrappedMonitors.getFirst();
            return event -> {
                invoker.accept(event);
                firstMonitor.accept(event, false);
            };
        }
        ObjBooleanBiConsumer[] unwrappedMonitorsArray = unwrappedMonitors.toArray(new ObjBooleanBiConsumer[0]);
        return event -> {
            invoker.accept(event);
            for (ObjBooleanBiConsumer monitor : unwrappedMonitorsArray) {
                monitor.accept(event, false);
            }
        };
    }

    static <T extends Event & Cancellable> Predicate<T> createCancellableMonitoringInvoker(Class<T> eventType, int eventCharacteristics, List<EventListener> listeners, List<EventListener> monitoringListeners) {
        Predicate cancellableInvoker = InvokerFactory.createCancellableInvoker(listeners);
        if (monitoringListeners.isEmpty()) {
            return cancellableInvoker;
        }
        List<ObjBooleanBiConsumer<ObjBooleanBiConsumer>> unwrappedMonitors = InvokerFactoryUtils.unwrapMonitors(monitoringListeners);
        if (Constants.isMonitorAware(eventCharacteristics)) {
            if (!MutableEvent.class.isAssignableFrom(eventType)) {
                throw new UnsupportedOperationException("This version of EventBus only supports EventCharacteristics.MonitorAware on MutableEvent");
            }
            if (monitoringListeners.size() == 1) {
                ObjBooleanBiConsumer firstMonitor = unwrappedMonitors.getFirst();
                return event -> {
                    boolean cancelled = cancellableInvoker.test(event);
                    MutableEventInternals mutableEvent = (MutableEventInternals)((Object)event);
                    mutableEvent.isMonitoring = true;
                    firstMonitor.accept(event, cancelled);
                    mutableEvent.isMonitoring = false;
                    return cancelled;
                };
            }
            ObjBooleanBiConsumer[] unwrappedMonitorsArray = unwrappedMonitors.toArray(new ObjBooleanBiConsumer[0]);
            return event -> {
                boolean cancelled = cancellableInvoker.test(event);
                MutableEventInternals mutableEvent = (MutableEventInternals)((Object)event);
                mutableEvent.isMonitoring = true;
                for (ObjBooleanBiConsumer monitor : unwrappedMonitorsArray) {
                    monitor.accept(event, cancelled);
                }
                mutableEvent.isMonitoring = false;
                return cancelled;
            };
        }
        if (monitoringListeners.size() == 1) {
            ObjBooleanBiConsumer firstMonitor = unwrappedMonitors.getFirst();
            return event -> {
                boolean cancelled = cancellableInvoker.test(event);
                firstMonitor.accept(event, cancelled);
                return cancelled;
            };
        }
        ObjBooleanBiConsumer[] unwrappedMonitorsArray = unwrappedMonitors.toArray(new ObjBooleanBiConsumer[0]);
        return event -> {
            boolean cancelled = cancellableInvoker.test(event);
            for (ObjBooleanBiConsumer monitor : unwrappedMonitorsArray) {
                monitor.accept(event, cancelled);
            }
            return cancelled;
        };
    }

    private static <T extends Event> Consumer<T> createInvoker(List<EventListener> listeners) {
        return InvokerFactory.createInvokerFromUnwrapped(InvokerFactoryUtils.unwrapConsumers(listeners));
    }

    private static <T extends Event & Cancellable> Predicate<T> createCancellableInvoker(List<EventListener> listeners) {
        if (listeners.size() <= UNWRAP_CANCELLABLE_THRESHOLD) {
            if (listeners.stream().allMatch(EventListenerImpl.WrappedConsumerListener.class::isInstance)) {
                if (listeners.stream().map(EventListenerImpl.WrappedConsumerListener.class::cast).noneMatch(EventListenerImpl.WrappedConsumerListener::alwaysCancelling)) {
                    return InvokerFactory.createCancellableInvokerFromUnwrappedNoChecks(InvokerFactoryUtils.unwrapConsumers(listeners));
                }
            }
        }
        return InvokerFactory.createCancellableInvokerFromUnwrapped(InvokerFactoryUtils.unwrapPredicates(listeners));
    }

    private static <T extends Event> Consumer<T> createInvokerFromUnwrapped(List<Consumer<T>> listeners) {
        return switch (listeners.size()) {
            case 0 -> Constants.getNoOpConsumer();
            case 1 -> listeners.getFirst();
            case 2 -> {
                Consumer<T> first = listeners.getFirst();
                Consumer<T> second = listeners.getLast();
                yield first.andThen(second);
            }
            case 3 -> {
                Consumer first = listeners.getFirst();
                Consumer second = listeners.get(1);
                Consumer third = listeners.getLast();
                yield event -> {
                    first.accept(event);
                    second.accept(event);
                    third.accept(event);
                };
            }
            case 4 -> {
                Consumer first = listeners.getFirst();
                Consumer second = listeners.get(1);
                Consumer third = listeners.get(2);
                Consumer fourth = listeners.getLast();
                yield event -> {
                    first.accept(event);
                    second.accept(event);
                    third.accept(event);
                    fourth.accept(event);
                };
            }
            default -> {
                Consumer[] listenersArray = listeners.toArray(new Consumer[0]);
                yield event -> {
                    for (Consumer listener : listenersArray) {
                        listener.accept(event);
                    }
                };
            }
        };
    }

    private static <T extends Event & Cancellable> Predicate<T> createCancellableInvokerFromUnwrappedNoChecks(List<Consumer<T>> listeners) {
        return switch (listeners.size()) {
            case 0 -> Constants.getNoOpPredicate();
            case 1 -> {
                Consumer first = listeners.getFirst();
                yield event -> {
                    first.accept(event);
                    return false;
                };
            }
            case 2 -> {
                Consumer first = listeners.getFirst();
                Consumer second = listeners.getLast();
                yield event -> {
                    first.accept(event);
                    second.accept(event);
                    return false;
                };
            }
            case 3 -> {
                Consumer first = listeners.getFirst();
                Consumer second = listeners.get(1);
                Consumer third = listeners.getLast();
                yield event -> {
                    first.accept(event);
                    second.accept(event);
                    third.accept(event);
                    return false;
                };
            }
            case 4 -> {
                Consumer first = listeners.getFirst();
                Consumer second = listeners.get(1);
                Consumer third = listeners.get(2);
                Consumer fourth = listeners.getLast();
                yield event -> {
                    first.accept(event);
                    second.accept(event);
                    third.accept(event);
                    fourth.accept(event);
                    return false;
                };
            }
            default -> {
                Consumer[] listenersArray = listeners.toArray(new Consumer[0]);
                yield event -> {
                    for (Consumer listener : listenersArray) {
                        listener.accept(event);
                    }
                    return false;
                };
            }
        };
    }

    private static <T extends Event & Cancellable> Predicate<T> createCancellableInvokerFromUnwrapped(List<Predicate<T>> listeners) {
        return switch (listeners.size()) {
            case 0 -> Constants.getNoOpPredicate();
            case 1 -> listeners.getFirst();
            case 2 -> {
                Predicate<T> first = listeners.getFirst();
                Predicate<T> second = listeners.getLast();
                yield first.or(second);
            }
            case 3 -> {
                Predicate first = listeners.getFirst();
                Predicate second = listeners.get(1);
                Predicate third = listeners.getLast();
                yield event -> first.test(event) || second.test(event) || third.test(event);
            }
            default -> {
                Predicate[] listenersArray = listeners.toArray(new Predicate[0]);
                yield event -> {
                    for (Predicate listener : listenersArray) {
                        if (!listener.test(event)) continue;
                        return true;
                    }
                    return false;
                };
            }
        };
    }
}

