/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.internal;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import net.minecraftforge.eventbus.api.event.characteristic.MonitorAware;
import net.minecraftforge.eventbus.api.event.characteristic.SelfDestructing;
import net.minecraftforge.eventbus.api.listener.EventListener;
import net.minecraftforge.eventbus.internal.CancellableEventBusImpl;
import net.minecraftforge.eventbus.internal.Constants;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.eventbus.internal.EventBusImpl;
import org.jspecify.annotations.Nullable;

public sealed interface AbstractEventBusImpl<T extends Event, I>
extends EventBus<T>
permits CancellableEventBusImpl, EventBusImpl {
    public ArrayList<EventListener> backingList();

    public ArrayList<EventListener> monitorBackingList();

    public List<AbstractEventBusImpl<?, ?>> children();

    public AtomicBoolean shutdownFlag();

    public AtomicBoolean alreadyInvalidated();

    public int eventCharacteristics();

    public static int computeEventCharacteristics(Class<?> eventType) {
        int characteristics = 0;
        if (SelfDestructing.class.isAssignableFrom(eventType)) {
            characteristics |= 1;
        }
        if (MonitorAware.class.isAssignableFrom(eventType)) {
            characteristics |= 2;
        }
        if (Cancellable.class.isAssignableFrom(eventType)) {
            characteristics |= 4;
        }
        if (InheritableEvent.class.isAssignableFrom(eventType)) {
            characteristics |= 8;
        }
        return characteristics;
    }

    public static List<AbstractEventBusImpl<?, ?>> makeEventChildrenList(Class<?> eventType, int eventCharacteristics) {
        if (Constants.notInheritable(eventCharacteristics) || Modifier.isFinal(eventType.getModifiers())) {
            return Collections.emptyList();
        }
        Class<?>[] permittedSubclasses = eventType.getPermittedSubclasses();
        if (permittedSubclasses != null) {
            return new ArrayList(permittedSubclasses.length);
        }
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public EventListener addListener(EventListener listener) {
        ArrayList<EventListener> arrayList = this.backingList();
        synchronized (arrayList) {
            boolean added;
            boolean bl = added = listener.priority() == -128 ? this.monitorBackingList().add(listener) : this.backingList().add(listener);
            if (added) {
                this.invalidateInvoker();
                if (this.notInheritable()) {
                    return listener;
                }
                for (AbstractEventBusImpl<?, ?> child : this.children()) {
                    child.addListener(listener);
                }
            }
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public void removeListener(EventListener listener) {
        ArrayList<EventListener> arrayList = this.backingList();
        synchronized (arrayList) {
            boolean removed;
            boolean bl = removed = listener.priority() == -128 ? this.monitorBackingList().remove(listener) : this.backingList().remove(listener);
            if (removed) {
                this.invalidateInvoker();
                if (this.notInheritable()) {
                    return;
                }
                for (AbstractEventBusImpl<?, ?> child : this.children()) {
                    child.removeListener(listener);
                }
            }
        }
    }

    public @Nullable I maybeGetInvoker();

    public void invalidateInvoker();

    public I buildInvoker();

    public void setNoOpInvoker();

    default public I getInvoker() {
        I invoker = this.maybeGetInvoker();
        if (invoker == null) {
            invoker = this.buildInvoker();
        }
        return invoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void startup() {
        if (!this.shutdownFlag().compareAndSet(true, false)) {
            return;
        }
        ArrayList<EventListener> arrayList = this.backingList();
        synchronized (arrayList) {
            this.alreadyInvalidated().set(false);
            this.invalidateInvoker();
        }
        this.children().forEach(AbstractEventBusImpl::startup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void shutdown() {
        if (!this.shutdownFlag().compareAndSet(false, true)) {
            return;
        }
        ArrayList<EventListener> arrayList = this.backingList();
        synchronized (arrayList) {
            this.setNoOpInvoker();
            this.alreadyInvalidated().set(true);
        }
        this.children().forEach(AbstractEventBusImpl::shutdown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void dispose() {
        this.shutdown();
        ArrayList<EventListener> arrayList = this.backingList();
        synchronized (arrayList) {
            this.backingList().clear();
            this.monitorBackingList().clear();
            this.backingList().trimToSize();
            this.monitorBackingList().trimToSize();
        }
        this.children().forEach(AbstractEventBusImpl::dispose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void trim() {
        ArrayList<EventListener> arrayList = this.backingList();
        synchronized (arrayList) {
            this.backingList().trimToSize();
            this.monitorBackingList().trimToSize();
        }
    }

    private boolean notInheritable() {
        return (this.eventCharacteristics() & 8) == 0;
    }
}

