/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.service;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.EnumSet;
import java.util.ServiceLoader;
import net.minecraftforge.eventbus.IEventBusEngine;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class ModLauncherService
implements ILaunchPluginService {
    private IEventBusEngine eventBusEngine;
    private static final EnumSet<ILaunchPluginService.Phase> DOIT = EnumSet.of(ILaunchPluginService.Phase.BEFORE);
    private static final EnumSet<ILaunchPluginService.Phase> YAY = EnumSet.of(ILaunchPluginService.Phase.AFTER);
    private static final EnumSet<ILaunchPluginService.Phase> NAY = EnumSet.noneOf(ILaunchPluginService.Phase.class);

    public String name() {
        return "eventbus";
    }

    public IEventBusEngine getEventBusEngine() {
        if (this.eventBusEngine == null) {
            ModuleLayer service = (ModuleLayer)Launcher.INSTANCE.findLayerManager().flatMap(lm -> lm.getLayer(IModuleLayerManager.Layer.PLUGIN)).orElseThrow();
            this.eventBusEngine = ServiceLoader.load(service, IEventBusEngine.class).findFirst().orElseThrow();
        }
        return this.eventBusEngine;
    }

    public int processClassWithFlags(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        return "classloading".equals(reason) ? this.getEventBusEngine().processClass(classNode, classType) : 0;
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        if (isEmpty) {
            return this.getEventBusEngine().findASMEventDispatcher(classType) ? DOIT : NAY;
        }
        return this.getEventBusEngine().handlesClass(classType) ? YAY : NAY;
    }
}

