/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import net.minecraftforge.eventbus.EventAccessTransformer;
import net.minecraftforge.eventbus.EventSubscriptionTransformer;
import net.minecraftforge.eventbus.Logging;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public enum EventBusEngine {
    INSTANCE;

    private final EventSubscriptionTransformer subscriptionTransformer;
    private final EventAccessTransformer accessTransformer;

    private EventBusEngine() {
        LogManager.getLogger((String)"EVENTBUS").debug(Logging.EVENTBUS, "Loading EventBus transformer");
        this.subscriptionTransformer = new EventSubscriptionTransformer();
        this.accessTransformer = new EventAccessTransformer();
    }

    public ClassNode processClass(ClassNode classNode, Type classType) {
        this.subscriptionTransformer.transform(classNode, classType);
        this.accessTransformer.transform(classNode, classType);
        return classNode;
    }

    public boolean handlesClass(Type classType) {
        String name = classType.getClassName();
        return !name.equals("net.minecraftforge.eventbus.api.Event") && !name.startsWith("net.minecraft.") && name.indexOf(46) != -1;
    }
}

