/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.jodah.typetools.TypeResolver;
import net.minecraftforge.eventbus.ASMEventHandler;
import net.minecraftforge.eventbus.EventBusErrorMessage;
import net.minecraftforge.eventbus.ListenerList;
import net.minecraftforge.eventbus.Logging;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.GenericEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventExceptionHandler;
import net.minecraftforge.eventbus.api.IEventListener;
import net.minecraftforge.eventbus.api.IGenericEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventBus
implements IEventExceptionHandler,
IEventBus {
    private static final Logger LOGGER = LogManager.getLogger((String)"EVENTBUS");
    private static int maxID = 0;
    private ConcurrentHashMap<Object, ArrayList<IEventListener>> listeners = new ConcurrentHashMap();
    private final int busID = maxID++;
    private final IEventExceptionHandler exceptionHandler;

    public EventBus() {
        ListenerList.resize(this.busID + 1);
        this.exceptionHandler = this;
    }

    public EventBus(@Nonnull IEventExceptionHandler handler) {
        Objects.requireNonNull(handler, "EventBus exception handler can not be null");
        this.exceptionHandler = handler;
    }

    private void registerClass(Class<?> clazz) {
        Arrays.stream(clazz.getMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.isAnnotationPresent(SubscribeEvent.class)).forEach(m -> this.registerListener(clazz, (Method)m, (Method)m));
    }

    private Optional<Method> getDeclMethod(Class<?> clz, Method in) {
        try {
            return Optional.of(clz.getDeclaredMethod(in.getName(), in.getParameterTypes()));
        }
        catch (NoSuchMethodException nse) {
            return Optional.empty();
        }
    }

    private void registerObject(Object obj) {
        HashSet classes = new HashSet();
        this.typesFor(obj.getClass(), classes);
        Arrays.stream(obj.getClass().getMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).forEach(m -> classes.stream().map(c -> this.getDeclMethod((Class<?>)c, (Method)m)).filter(rm -> rm.isPresent() && ((Method)rm.get()).isAnnotationPresent(SubscribeEvent.class)).findFirst().ifPresent(rm -> this.registerListener(obj, (Method)m, (Method)rm.get())));
    }

    private void typesFor(Class<?> clz, Set<Class<?>> visited) {
        if (clz.getSuperclass() == null) {
            return;
        }
        this.typesFor(clz.getSuperclass(), visited);
        Arrays.stream(clz.getInterfaces()).forEach(i -> this.typesFor((Class<?>)i, visited));
        visited.add(clz);
    }

    @Override
    public void register(Object target) {
        if (this.listeners.containsKey(target)) {
            return;
        }
        if (target.getClass() == Class.class) {
            this.registerClass((Class)target);
        } else {
            this.registerObject(target);
        }
    }

    private void registerListener(Object target, Method method, Method real) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation. It has " + parameterTypes.length + " arguments, but event handler methods require a single argument only.");
        }
        Class<?> eventType = parameterTypes[0];
        if (!Event.class.isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation, but takes an argument that is not an Event subtype : " + eventType);
        }
        this.register(eventType, target, real);
    }

    private <T extends Event> Predicate<T> passCancelled(boolean ignored) {
        return e -> !e.isCancelable() || ignored || !e.isCanceled();
    }

    private <T extends GenericEvent<F>, F> Predicate<T> passGenericFilter(Class<F> type) {
        return e -> e.getGenericType() == type;
    }

    @Override
    public <T extends Event> void addListener(Consumer<T> consumer) {
        this.addListener(EventPriority.NORMAL, consumer);
    }

    @Override
    public <T extends Event> void addListener(EventPriority priority, Consumer<T> consumer) {
        this.addListener(priority, false, consumer);
    }

    @Override
    public <T extends Event> void addListener(EventPriority priority, boolean receiveCancelled, Consumer<T> consumer) {
        this.addListener(priority, this.passCancelled(receiveCancelled), consumer);
    }

    @Override
    public <T extends Event> void addListener(EventPriority priority, boolean receiveCancelled, Class<T> eventType, Consumer<T> consumer) {
        this.addListener(priority, this.passCancelled(receiveCancelled), eventType, consumer);
    }

    @Override
    public <T extends GenericEvent<F>, F> void addGenericListener(Class<F> genericClassFilter, Consumer<T> consumer) {
        this.addGenericListener(genericClassFilter, EventPriority.NORMAL, consumer);
    }

    @Override
    public <T extends GenericEvent<F>, F> void addGenericListener(Class<F> genericClassFilter, EventPriority priority, Consumer<T> consumer) {
        this.addGenericListener(genericClassFilter, priority, false, consumer);
    }

    @Override
    public <T extends GenericEvent<F>, F> void addGenericListener(Class<F> genericClassFilter, EventPriority priority, boolean receiveCancelled, Consumer<T> consumer) {
        this.addListener(priority, this.passGenericFilter(genericClassFilter).and(this.passCancelled(receiveCancelled)), consumer);
    }

    @Override
    public <T extends GenericEvent<F>, F> void addGenericListener(Class<F> genericClassFilter, EventPriority priority, boolean receiveCancelled, Class<T> eventType, Consumer<T> consumer) {
        this.addListener(priority, this.passGenericFilter(genericClassFilter).and(this.passCancelled(receiveCancelled)), eventType, consumer);
    }

    private <T extends Event> void addListener(EventPriority priority, Predicate<? super T> filter, Class<T> eventClass, Consumer<T> consumer) {
        this.addToListeners(consumer, eventClass, e -> Stream.of(e).map(eventClass::cast).filter(filter).forEach(consumer), priority);
    }

    private <T extends Event> void addListener(EventPriority priority, Predicate<? super T> filter, Consumer<T> consumer) {
        Class eventClass = TypeResolver.resolveRawArgument(Consumer.class, consumer.getClass());
        if (Objects.equals(eventClass, Event.class)) {
            LOGGER.warn("Attempting to add a Lambda listener with computed generic type of Event. Are you sure this is what you meant? NOTE : there are complex lambda forms where the generic type information is erased and cannot be recovered at runtime.");
        }
        this.addListener(priority, filter, eventClass, consumer);
    }

    private void register(Class<?> eventType, Object target, Method method) {
        try {
            ASMEventHandler asm = new ASMEventHandler(target, method, IGenericEvent.class.isAssignableFrom(eventType));
            this.addToListeners(target, eventType, asm, asm.getPriority());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LogManager.getLogger((String)"EVENTBUS").error("Error registering event handler: {} {}", eventType, (Object)method, (Object)e);
        }
    }

    private void addToListeners(Object target, Class<?> eventType, IEventListener listener, EventPriority priority) {
        try {
            Constructor<?> ctr = eventType.getConstructor(new Class[0]);
            ctr.setAccessible(true);
            Event event = (Event)ctr.newInstance(new Object[0]);
            event.getListenerList().register(this.busID, priority, listener);
            ArrayList others = this.listeners.computeIfAbsent(target, k -> new ArrayList());
            others.add(listener);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LogManager.getLogger((String)"EVENTBUS").error("Error registering event handler: {} {}", eventType, target, (Object)e);
        }
    }

    @Override
    public void unregister(Object object) {
        ArrayList<IEventListener> list = this.listeners.remove(object);
        if (list == null) {
            return;
        }
        for (IEventListener listener : list) {
            ListenerList.unregisterAll(this.busID, listener);
        }
    }

    @Override
    public boolean post(Event event) {
        int index;
        IEventListener[] listeners = event.getListenerList().getListeners(this.busID);
        try {
            for (index = 0; index < listeners.length; ++index) {
                listeners[index].invoke(event);
            }
        }
        catch (Throwable throwable) {
            this.exceptionHandler.handleException(this, event, listeners, index, throwable);
            throw new RuntimeException(throwable);
        }
        return event.isCancelable() ? event.isCanceled() : false;
    }

    @Override
    public void handleException(IEventBus bus, Event event, IEventListener[] listeners, int index, Throwable throwable) {
        LOGGER.error(Logging.EVENTBUS, () -> new EventBusErrorMessage(event, index, listeners, throwable));
    }
}

