/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.download;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.minecraftforge.util.logging.Log;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DownloadUtils {
    private static final int TIMEOUT = 5000;
    private static final int MAX_REDIRECTS = 3;

    private static URLConnection openConnection(URL url) throws IOException {
        URLConnection con = url.openConnection();
        con.setConnectTimeout(5000);
        con.setReadTimeout(5000);
        if (con instanceof HttpURLConnection) {
            HttpURLConnection hcon = (HttpURLConnection)con;
            hcon.setRequestProperty("User-Agent", "MinecraftForge-Utils");
            hcon.setRequestProperty("Accept", "application/json");
            hcon.setInstanceFollowRedirects(false);
        }
        return con;
    }

    private static InputStream connect(String address) throws IOException {
        URL url;
        URLConnection con;
        URI uri;
        try {
            uri = new URI(address);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        ArrayList<String> redirections = new ArrayList<String>();
        int redirects = 0;
        while ((con = DownloadUtils.openConnection(url = uri.toURL())) instanceof HttpURLConnection) {
            String location;
            HttpURLConnection hcon = (HttpURLConnection)con;
            int res = hcon.getResponseCode();
            if (res == 301 || res == 302) {
                location = hcon.getHeaderField("Location");
                redirections.add(location);
                hcon.disconnect();
                if (redirects == 2) {
                    throw new IOException(String.format("Too many redirects: %s -- redirections: [%s]", address, String.join((CharSequence)", ", redirections)));
                }
            } else {
                if (res != 404) break;
                throw new FileNotFoundException("Returned 404: " + address);
            }
            Log.debug((String)("Following redirect: " + location));
            uri = uri.resolve(location);
            ++redirects;
        }
        URLConnection connection = con;
        return connection.getInputStream();
    }

    private static <R, E extends Throwable> R sneak(Throwable t) throws E {
        throw t;
    }

    /*
     * Exception decompiling
     */
    public static byte[] downloadBytes(String url) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte @Nullable [] tryDownloadBytes(boolean silent, String url) {
        try {
            return DownloadUtils.downloadBytes(url);
        }
        catch (IOException e) {
            if (!silent) {
                e.printStackTrace(Log.WARN);
            }
            return null;
        }
    }

    public static String downloadString(String url) throws IOException {
        return new String(DownloadUtils.downloadBytes(url), StandardCharsets.UTF_8);
    }

    @Nullable
    public static String tryDownloadString(boolean silent, String url) {
        try {
            return DownloadUtils.downloadString(url);
        }
        catch (IOException e) {
            if (!silent) {
                e.printStackTrace(Log.WARN);
            }
            return null;
        }
    }

    public static void downloadFile(File target, String url) throws IOException {
        DownloadUtils.downloadFile(false, target, url);
    }

    public static void downloadFile(boolean silent, File target, String url) throws IOException {
        if (!silent) {
            Log.quiet((String)("Downloading " + url));
        }
        try (InputStream stream = DownloadUtils.connect(url);){
            Path path = target.toPath();
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.copy(stream, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (DownloadFailedException e) {
            throw new IOException(url, e);
        }
    }

    public static boolean tryDownloadFile(boolean silent, File target, String url) {
        try {
            DownloadUtils.downloadFile(silent, target, url);
            return true;
        }
        catch (IOException e) {
            if (!silent) {
                e.printStackTrace(Log.WARN);
            }
            return false;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class DownloadFailedException
    extends IOException {
        public DownloadFailedException(String url, Throwable cause) {
            super("Failed to download " + url, cause);
        }
    }
}

