/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.download;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.minecraftforge.util.logging.Log;
import org.jetbrains.annotations.Nullable;

public final class DownloadUtils {
    private static final TypeAdapter<String> STRING = new TypeAdapter<String>(){

        public String read(JsonReader in) throws IOException {
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (peek == JsonToken.BOOLEAN) {
                return Boolean.toString(in.nextBoolean());
            }
            return in.nextString();
        }

        public void write(JsonWriter out, String value) throws IOException {
            out.value(value);
        }
    };
    public static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().registerTypeAdapter(String.class, (Object)new TypeAdapter<String>(){

        public void write(JsonWriter out, String value) throws IOException {
            if (value == null || value.isEmpty()) {
                out.nullValue();
            } else {
                STRING.write(out, (Object)value);
            }
        }

        public String read(JsonReader in) throws IOException {
            String value = (String)STRING.read(in);
            return value != null && value.isEmpty() ? null : value;
        }
    }).create();
    private static final int TIMEOUT = 5000;
    private static final int MAX_REDIRECTS = 3;

    private static URLConnection getConnection(String address) throws IOException {
        URLConnection con;
        URI uri;
        try {
            uri = new URI(address);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        URL url = uri.toURL();
        ArrayList<String> redirections = new ArrayList<String>();
        int redirects = 0;
        while (true) {
            String location;
            con = url.openConnection();
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
            if (!(con instanceof HttpURLConnection)) break;
            HttpURLConnection hcon = (HttpURLConnection)con;
            hcon.setRequestProperty("User-Agent", "MinecraftMaven");
            hcon.setRequestProperty("accept", "application/json");
            hcon.setInstanceFollowRedirects(false);
            int res = hcon.getResponseCode();
            if (res == 301 || res == 302) {
                location = hcon.getHeaderField("Location");
                redirections.add(location);
                hcon.disconnect();
                if (redirects == 2) {
                    throw new IOException(String.format("Too many redirects: %s -- redirections: [%s]", address, String.join((CharSequence)", ", redirections)));
                }
            } else {
                if (res != 404) break;
                throw new FileNotFoundException("Returned 404: " + address);
            }
            Log.debug((Object)("Following redirect: " + location));
            uri = uri.resolve(location);
            url = uri.toURL();
            ++redirects;
        }
        return con;
    }

    /*
     * Exception decompiling
     */
    public static String downloadString(String url) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static String tryDownloadString(boolean silent, String url) {
        try {
            return DownloadUtils.downloadString(url);
        }
        catch (IOException e) {
            if (!silent) {
                Log.warn((Object)("Failed to download " + url));
                e.printStackTrace(Log.WARN);
            }
            return null;
        }
    }

    public static void downloadFile(File target, String url) throws IOException {
        DownloadUtils.downloadFile(false, target, url);
    }

    public static void downloadFile(boolean silent, File target, String url) throws IOException {
        if (!silent) {
            Log.quiet((Object)("Downloading " + url));
        }
        URLConnection connection = DownloadUtils.getConnection(url);
        Files.createDirectories(target.toPath().getParent(), new FileAttribute[0]);
        Files.copy(connection.getInputStream(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static boolean tryDownloadFile(boolean silent, File target, String url) {
        try {
            DownloadUtils.downloadFile(silent, target, url);
            return true;
        }
        catch (IOException e) {
            if (!silent) {
                Log.warn((Object)("Failed to download " + url));
                e.printStackTrace(Log.WARN);
            }
            return false;
        }
    }
}

