/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.download;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import net.minecraftforge.util.logging.SimpleLogger;
import org.jetbrains.annotations.Nullable;

public final class DownloadUtils {
    private static final TypeAdapter<String> STRING = new TypeAdapter<String>(){

        public String read(JsonReader in) throws IOException {
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (peek == JsonToken.BOOLEAN) {
                return Boolean.toString(in.nextBoolean());
            }
            return in.nextString();
        }

        public void write(JsonWriter out, String value) throws IOException {
            out.value(value);
        }
    };
    public static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().registerTypeAdapter(String.class, (Object)new TypeAdapter<String>(){

        public void write(JsonWriter out, String value) throws IOException {
            if (value == null || value.isEmpty()) {
                out.nullValue();
            } else {
                STRING.write(out, (Object)value);
            }
        }

        public String read(JsonReader in) throws IOException {
            String value = (String)STRING.read(in);
            return value != null && value.isEmpty() ? null : value;
        }
    }).create();

    @Nullable
    private static URLConnection getConnection(String address) {
        URL url;
        URI uri;
        try {
            uri = new URI(address);
            url = uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            SimpleLogger.getGlobal().error("Malformed URL: " + address);
            SimpleLogger.getGlobal().error(e::printStackTrace);
            return null;
        }
        try {
            int timeout = 5000;
            int max_redirects = 3;
            URLConnection con = null;
            for (int x = 0; x < max_redirects; ++x) {
                String location;
                con = url.openConnection();
                con.setConnectTimeout(timeout);
                con.setReadTimeout(timeout);
                if (!(con instanceof HttpURLConnection)) break;
                HttpURLConnection hcon = (HttpURLConnection)con;
                hcon.setRequestProperty("User-Agent", "MinecraftMaven");
                hcon.setRequestProperty("accept", "application/json");
                hcon.setInstanceFollowRedirects(false);
                int res = hcon.getResponseCode();
                if (res == 301 || res == 302) {
                    location = hcon.getHeaderField("Location");
                    hcon.disconnect();
                    if (x == max_redirects - 1) {
                        SimpleLogger.getGlobal().error("Invalid number of redirects: " + location);
                        return null;
                    }
                } else {
                    if (res != 404) break;
                    return null;
                }
                uri = uri.resolve(location);
                url = uri.toURL();
            }
            return con;
        }
        catch (IOException e) {
            SimpleLogger.getGlobal().error("Failed to establish connection to " + address);
            SimpleLogger.getGlobal().error(e::printStackTrace);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static String downloadString(String url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean downloadFile(File target, String url) {
        try {
            DownloadUtils.ensureParent(target);
            SimpleLogger.getGlobal().quiet("Downloading " + url);
            URLConnection connection = DownloadUtils.getConnection(url);
            if (connection != null) {
                Files.copy(connection.getInputStream(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
        }
        catch (IOException e) {
            SimpleLogger.getGlobal().warn("Failed to download " + url);
            SimpleLogger.getGlobal().warn(e::printStackTrace);
        }
        return false;
    }

    private static void ensureParent(File path) {
        File parent = path.getAbsoluteFile().getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
    }
}

