/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gitversion.gradle.changelog.shadow.net.minecraftforge.gradleutils.shared;

import java.io.File;
import java.util.Locale;
import java.util.Objects;
import javax.inject.Inject;
import net.minecraftforge.gitversion.gradle.changelog.shadow.net.minecraftforge.gradleutils.shared.EnhancedProblems;
import net.minecraftforge.gitversion.gradle.changelog.shadow.net.minecraftforge.gradleutils.shared.EnhancedTask;
import net.minecraftforge.gitversion.gradle.changelog.shadow.net.minecraftforge.gradleutils.shared.SharedUtil;
import net.minecraftforge.gitversion.gradle.changelog.shadow.net.minecraftforge.gradleutils.shared.Tool;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public abstract class ToolExecBase<P extends EnhancedProblems>
extends JavaExec {
    private final transient P problems;
    protected final DirectoryProperty defaultToolDir;

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    protected ToolExecBase(Class<P> problemsType, Tool tool) {
        this.problems = (EnhancedProblems)this.getObjectFactory().newInstance(problemsType, new Object[0]);
        ToolExecBase toolExecBase = this;
        if (toolExecBase instanceof EnhancedTask) {
            EnhancedTask enhancedTask = (EnhancedTask)((Object)toolExecBase);
            this.defaultToolDir = this.getObjectFactory().directoryProperty().value(enhancedTask.globalCaches().dir(tool.getName().toLowerCase(Locale.ENGLISH)).map(this.ensureFileLocationInternal()));
            this.setClasspath((FileCollection)this.getObjectFactory().fileCollection().from(new Object[]{enhancedTask.getTool(tool)}));
        } else {
            this.getProject().afterEvaluate(project -> ((EnhancedProblems)this.problems).reportToolExecNotEnhanced((Task)this));
            this.defaultToolDir = this.getObjectFactory().directoryProperty().value(this.getProjectLayout().getBuildDirectory().dir("minecraftforge/tools/%s/workDir".formatted(tool.getName().toLowerCase(Locale.ENGLISH))).map(this.ensureFileLocationInternal()));
            this.setClasspath((FileCollection)this.getObjectFactory().fileCollection().from(new Object[]{tool.get((Provider<? extends Directory>)this.getProjectLayout().getBuildDirectory().dir("minecraftforge/tools/" + tool.getName().toLowerCase(Locale.ENGLISH)).map(this.ensureFileLocationInternal()), this.getProviderFactory())}));
        }
        this.defaultToolDir.disallowChanges();
        this.defaultToolDir.finalizeValueOnRead();
        this.getMainClass().set((Object)Objects.requireNonNull(tool.getMainClass(), "Tool must have a main class"));
        this.getJavaLauncher().set(SharedUtil.launcherForStrictly(this.getJavaToolchainService(), tool.getJavaVersion()));
    }

    @Internal
    protected final P getProblems() {
        return this.problems;
    }

    private <T extends FileSystemLocation> Transformer<T, T> ensureFileLocationInternal() {
        return t -> (FileSystemLocation)((EnhancedProblems)this.problems).ensureFileLocation().transform(t);
    }

    @MustBeInvokedByOverriders
    protected void addArguments() {
    }

    public void exec() {
        if (this.getArgs().isEmpty()) {
            this.addArguments();
        } else {
            ((EnhancedProblems)this.problems).reportToolExecEagerArgs((Task)this);
        }
        this.getLogger().info("{} {}", (Object)this.getClasspath().getAsPath(), (Object)String.join((CharSequence)" ", this.getArgs()));
        super.exec();
    }

    protected final void args(String arg, Iterable<? extends File> files) {
        for (File file : files) {
            this.args(new Object[]{arg, file});
        }
    }

    protected final void args(String arg, FileSystemLocationProperty<? extends FileSystemLocation> fileProvider) {
        this.args(arg, fileProvider.getLocationOnly());
    }

    protected final void args(String arg, Provider<?> provider) {
        Object value = provider.map(it -> {
            Object object;
            if (it instanceof FileSystemLocation) {
                FileSystemLocation f = (FileSystemLocation)it;
                object = f.getAsFile();
            } else {
                object = it;
            }
            return object;
        }).get();
        this.args(new Object[]{arg, String.valueOf(value)});
    }

    protected final void argOnlyIf(String arg, Provider<Boolean> onlyIf) {
        this.argOnlyIf(arg, task -> onlyIf.isPresent() && (Boolean)onlyIf.getOrElse((Object)false) != false);
    }

    protected final void argOnlyIf(String arg, Spec<? super ToolExecBase<?>> onlyIf) {
        if (onlyIf.isSatisfiedBy((Object)this)) {
            this.args(new Object[]{arg});
        }
    }
}

