/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gitversion.gradle.changelog;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

abstract class CopyChangelog
extends DefaultTask
implements HasPublicType {
    static final String NAME = "copyChangelog";

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    public CopyChangelog(ProjectLayout layout) {
        this.setDescription("Copies a changelog file to this project's build directory.");
        this.getOutputFile().convention(layout.getBuildDirectory().file("changelog.txt"));
    }

    @Internal
    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(DefaultTask.class);
    }

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @InputFile
    public abstract RegularFileProperty getInputFile();

    @TaskAction
    public void exec() {
        byte[] input;
        try {
            input = (byte[])this.getProviders().fileContents((Provider)this.getInputFile()).getAsBytes().get();
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
        File output = ((RegularFile)this.getOutputFile().get()).getAsFile();
        if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
            throw new IllegalStateException();
        }
        try {
            Files.write(output.toPath(), input, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

