/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformers.gradle;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.inject.Inject;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersContainer;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersContainerInternal;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersPlugin;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersProblems;
import net.minecraftforge.accesstransformers.gradle.ArtifactAccessTransformer;
import net.minecraftforge.accesstransformers.gradle.Constants;
import net.minecraftforge.accesstransformers.gradle.Tools;
import net.minecraftforge.accesstransformers.gradle.Util;
import net.minecraftforge.accesstransformers.gradle.shadow.net.minecraftforge.gradleutils.shared.Closures;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.JavaLauncher;

abstract class AccessTransformersContainerImpl
implements AccessTransformersContainerInternal {
    private final AccessTransformersPlugin plugin;
    private final AccessTransformersProblems problems;
    private final Project project;
    private final Attribute<Boolean> attribute;
    private final OptionsImpl options;

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    public AccessTransformersContainerImpl(Project project, Attribute<Boolean> attribute, Action<? super AccessTransformersContainer.Options> options) {
        this.project = project;
        this.plugin = (AccessTransformersPlugin)project.getPlugins().getPlugin(AccessTransformersPlugin.class);
        this.problems = (AccessTransformersProblems)this.getObjects().newInstance(AccessTransformersProblems.class, new Object[0]);
        this.attribute = Objects.requireNonNull(attribute);
        this.options = (OptionsImpl)this.getObjects().newInstance(OptionsImpl.class, new Object[]{project});
        options.execute((Object)this.options);
        project.afterEvaluate(this::finish);
    }

    private void finish(Project project) {
        this.validateATFile(this.attribute, this.options.config);
        project.dependencies(Closures.consumer(this, dependencies -> {
            dependencies.attributesSchema(attributesSchema -> {
                if (attributesSchema.hasAttribute(this.attribute)) {
                    throw new IllegalStateException("Another project in this build is already using this attribute for AccessTransformers: " + String.valueOf(this.attribute));
                }
                attributesSchema.attribute(this.attribute);
            });
            dependencies.getArtifactTypes().named("jar", type -> type.getAttributes().attribute(this.attribute, (Object)false));
            dependencies.registerTransform(ArtifactAccessTransformer.class, spec -> {
                spec.parameters(parameters -> {
                    parameters.getConfig().set((Provider)this.options.config);
                    parameters.getLogLevel().set(this.options.logLevel);
                    parameters.getClasspath().setFrom((Iterable)this.options.classpath);
                    parameters.getMainClass().set(this.options.mainClass);
                    parameters.getJavaLauncher().set(this.options.javaLauncher.map(Util.LAUNCHER_EXECUTABLE));
                    parameters.getArgs().set(this.options.args.map(Util::listToString));
                    parameters.getCachesDir().convention((Provider)this.plugin.localCaches());
                });
                this.setAttributes(spec.getFrom(), false);
                this.setAttributes(spec.getTo(), true);
            });
        }));
    }

    private void validateATFile(Attribute<Boolean> attribute, RegularFileProperty atFileProperty) {
        String atFileContents;
        RegularFile atFileSource;
        try {
            atFileSource = (RegularFile)atFileProperty.get();
        }
        catch (IllegalStateException e) {
            throw this.problems.accessTransformerConfigNotDefined(new RuntimeException("Failed to resolve config file property", e), attribute);
        }
        File atFile = atFileSource.getAsFile();
        String atFilePath = this.getProjectLayout().getProjectDirectory().getAsFile().toPath().relativize(atFile.toPath()).toString();
        if (!atFile.exists()) {
            throw this.problems.accessTransformerConfigMissing(new RuntimeException(new FileNotFoundException("Config file does not exist at " + atFilePath)), attribute, atFilePath);
        }
        try {
            atFileContents = (String)this.getProviders().fileContents(atFileSource).getAsText().get();
        }
        catch (Throwable e) {
            throw this.problems.accessTransformerConfigUnreadable(new RuntimeException(new IOException("Failed to read config file at " + atFilePath, e)), attribute, atFilePath);
        }
        if (atFileContents.isBlank()) {
            throw this.problems.accessTransformerConfigEmpty(new IllegalStateException("Config file must not be blank at " + atFilePath), attribute, atFilePath);
        }
    }

    private void setAttributes(AttributeContainer attributes, boolean value) {
        attributes.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar").attribute(this.attribute, (Object)value);
    }

    @Override
    public Attribute<Boolean> getAttribute() {
        return this.attribute;
    }

    @Override
    public void options(Action<? super AccessTransformersContainer.Options> action) {
        action.execute((Object)this.options);
    }

    @Override
    public Dependency dep(Object dependencyNotation, @DelegatesTo(value=Dependency.class) @ClosureParams(value=SimpleType.class, options={"org.gradle.api.artifacts.Dependency"}) Closure<?> closure) {
        return this.project.getDependencies().create(dependencyNotation, closure.compose(Closures.unaryOperator(dependency -> {
            if (dependency instanceof HasConfigurableAttributes) {
                HasConfigurableAttributes d = (HasConfigurableAttributes)dependency;
                d.attributes(a -> a.attribute(this.attribute, (Object)true));
            } else {
                this.problems.reportIllegalTargetDependency((Dependency)dependency);
            }
            return dependency;
        })));
    }

    @Override
    public Provider<?> dep(Provider<?> dependencyNotation, @DelegatesTo(value=Dependency.class) @ClosureParams(value=SimpleType.class, options={"org.gradle.api.artifacts.Dependency"}) Closure<?> closure) {
        Object object;
        if (dependencyNotation.isPresent() && (object = dependencyNotation.get()) instanceof ExternalModuleDependencyBundle) {
            ExternalModuleDependencyBundle bundle = (ExternalModuleDependencyBundle)object;
            return this.getObjects().property(ExternalModuleDependencyBundle.class).value(this.getProviders().provider(() -> (MappedExternalModuleDependencyBundle)DefaultGroovyMethods.collect((Iterable)bundle, (Collection)new MappedExternalModuleDependencyBundle(), Closures.unaryOperator(d -> (MinimalExternalModuleDependency)this.dep(d, closure)))));
        }
        return this.getObjects().property(Dependency.class).value(dependencyNotation.map(d -> this.dep(d, closure)));
    }

    static abstract class OptionsImpl
    implements AccessTransformersContainerInternal.Options {
        private final Property<LogLevel> logLevel = this.getObjects().property(LogLevel.class);
        private final RegularFileProperty config = this.getObjects().fileProperty();
        private final ConfigurableFileCollection classpath = this.getObjects().fileCollection();
        private final Property<String> mainClass = this.getObjects().property(String.class);
        private final Property<JavaLauncher> javaLauncher = this.getObjects().property(JavaLauncher.class);
        private final ListProperty<Object> args = this.getObjects().listProperty(Object.class);

        @Inject
        protected abstract ObjectFactory getObjects();

        @Inject
        public OptionsImpl(Project project) {
            AccessTransformersPlugin plugin = (AccessTransformersPlugin)project.getPlugins().getPlugin(AccessTransformersPlugin.class);
            this.logLevel.convention((Object)LogLevel.INFO);
            this.classpath.from(new Object[]{plugin.getTool(Tools.ACCESSTRANSFORMERS)});
            this.javaLauncher.convention(Util.launcherFor(project, Tools.ACCESSTRANSFORMERS.getJavaVersion()));
            this.args.convention(Constants.AT_DEFAULT_ARGS);
        }

        @Override
        public RegularFileProperty getConfig() {
            return this.config;
        }

        @Override
        public Property<LogLevel> getLogLevel() {
            return this.logLevel;
        }

        @Override
        public ConfigurableFileCollection getClasspath() {
            return this.classpath;
        }

        @Override
        public Property<String> getMainClass() {
            return this.mainClass;
        }

        @Override
        public Property<JavaLauncher> getJavaLauncher() {
            return this.javaLauncher;
        }

        @Override
        public ListProperty<Object> getArgs() {
            return this.args;
        }
    }

    private static class MappedExternalModuleDependencyBundle
    extends ArrayList<MinimalExternalModuleDependency>
    implements ExternalModuleDependencyBundle {
        private static final long serialVersionUID = -5641567719847374245L;

        private MappedExternalModuleDependencyBundle() {
        }
    }
}

