/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformers.gradle;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersProblems;
import net.minecraftforge.accesstransformers.gradle.Util;
import net.minecraftforge.accesstransformers.gradle.shadow.net.minecraftforge.util.hash.HashStore;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ProcessExecutionException;

public abstract class ArtifactAccessTransformer
implements TransformAction<Parameters> {
    private static final Logger LOGGER = Logging.getLogger(ArtifactAccessTransformer.class);
    private static final Pattern ARG_INJAR = Pattern.compile("{inJar}", 16);
    private static final Pattern ARG_ATFILE = Pattern.compile("{atFile}", 16);
    private static final Pattern ARG_OUTJAR = Pattern.compile("{outJar}", 16);
    private static final Pattern ARG_LOGFILE = Pattern.compile("{logFile}", 16);
    private final AccessTransformersProblems problems = (AccessTransformersProblems)this.getObjects().newInstance(AccessTransformersProblems.class, new Object[0]);

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @InputArtifact
    protected abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(TransformOutputs outputs) {
        Parameters parameters = (Parameters)this.getParameters();
        File inJar = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        File atFile = (File)parameters.getConfig().map(RegularFile::getAsFile).get();
        String outJarName = inJar.getName().replace(".jar", "-at.jar");
        File outJar = this.file(outJarName);
        File logFile = this.file(outJar.getName() + ".log");
        DirectoryProperty cachesDir = parameters.getCachesDir();
        HashStore cache = new HashStore(((Directory)cachesDir.get()).getAsFile()).load(((RegularFile)cachesDir.file(outJarName + ".cache").get()).getAsFile()).add("atFile", atFile).add("inJar", inJar).add("outJar", outJar);
        if (outJar.exists() && cache.isSame()) {
            LOGGER.info("Access transformer output up-to-date, skipping transformation for {}", (Object)inJar.getName());
        } else {
            LOGGER.info("Access transformer started. Input jar: {}", (Object)inJar.getAbsolutePath());
            ExecResult result = this.getExecOperations().javaexec(exec -> {
                LogLevel logLevel = (LogLevel)parameters.getLogLevel().get();
                PipedOutputStream stream = Util.toLog(s -> LOGGER.log(logLevel, s));
                exec.setStandardOutput((OutputStream)stream);
                exec.setErrorOutput((OutputStream)stream);
                exec.setExecutable((String)parameters.getJavaLauncher().get());
                exec.setClasspath((FileCollection)parameters.getClasspath());
                Util.setOptional(exec.getMainClass(), parameters.getMainClass());
                Map<Pattern, String> substitutions = Map.of(ARG_INJAR, inJar.getAbsolutePath(), ARG_ATFILE, atFile.getAbsolutePath(), ARG_OUTJAR, outJar.getAbsolutePath(), ARG_LOGFILE, logFile.getAbsolutePath());
                exec.setArgs(((List)parameters.getArgs().get()).stream().map(arg -> ArtifactAccessTransformer.replace(arg, substitutions)).collect(Collectors.toList()));
            });
            try {
                result.rethrowFailure().assertNormalExitValue();
            }
            catch (ProcessExecutionException e) {
                throw this.problems.accessTransformerFailed((RuntimeException)((Object)e), inJar, atFile, logFile);
            }
            LOGGER.info("Access transformer completed. Output jar: {}", (Object)outJar.getAbsolutePath());
            cache.add("outJar", outJar).save();
        }
        Path output = outputs.file((Object)outJarName).toPath();
        try {
            Files.copy(outJar.toPath(), output, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw this.problems.accessTransformerCannotWriteOutput(e, output);
        }
    }

    private static String replace(String s, Map<Pattern, String> substitutions) {
        for (Map.Entry<Pattern, String> entry : substitutions.entrySet()) {
            s = entry.getKey().matcher(s).replaceAll(Matcher.quoteReplacement(entry.getValue()));
        }
        return s;
    }

    private File file(String path) {
        return ((RegularFile)((Parameters)this.getParameters()).getCachesDir().file(path).map(this.problems.ensureFileLocation()).get()).getAsFile();
    }

    public static interface Parameters
    extends TransformParameters {
        @InputFiles
        @Classpath
        public ConfigurableFileCollection getClasspath();

        @Console
        public Property<LogLevel> getLogLevel();

        @Optional
        @Input
        public Property<String> getMainClass();

        @Input
        public Property<String> getJavaLauncher();

        @Input
        public ListProperty<String> getArgs();

        @InputFile
        public RegularFileProperty getConfig();

        @InputDirectory
        public DirectoryProperty getCachesDir();
    }
}

