/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformers.gradle;

import java.io.File;
import java.nio.file.Path;
import javax.inject.Inject;
import net.minecraftforge.accesstransformers.gradle.Util;
import net.minecraftforge.accesstransformers.gradle.shadow.net.minecraftforge.gradleutils.shared.EnhancedProblems;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.problems.Severity;

abstract class AccessTransformersProblems
extends EnhancedProblems {
    private static final long serialVersionUID = -5334414678185075096L;

    @Inject
    public AccessTransformersProblems() {
        super("accesstransformers", "AccessTransformers Gradle");
    }

    void reportIllegalTargetDependency(Dependency dependency) {
        String dependencyToString = Util.toString(dependency);
        this.getLogger().error("ERROR: Cannot access transform target dependency: {}", (Object)dependencyToString);
        this.getReporter().report(this.id("access-transformer-illegal-dependency-target", "Cannot access transform target dependency"), spec -> spec.details("Cannot apply Access Transformers to a dependency that cannot be configured with attributes.\nDependency: %s".formatted(dependencyToString)).severity(Severity.ERROR).stackLocation().solution("Use a valid dependency type (i.e. an external module, or any dependency type that implements `HasConfigurableAttributes`.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    RuntimeException accessTransformerConfigNotDefined(Exception e, Attribute<Boolean> attribute) {
        return this.getReporter().throwing((Throwable)e, this.id("access-transformer-config-not-defined", "Access transformer config not defined"), spec -> spec.details("The access transformer cannot transform the input artifact without a configuration file.\nAttribute: %s".formatted(attribute)).severity(Severity.ERROR).solution("Ensure you have defined your configuration file.").solution("Do not use AccessTransformers if you do not need to.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    RuntimeException accessTransformerConfigMissing(Exception e, Attribute<Boolean> attribute, File atFile) {
        return this.getReporter().throwing((Throwable)e, this.id("access-transformer-config-missing", "Access transformer config file not found"), spec -> spec.details("The access transformer cannot transform the input artifact because the configuration file could not be found.\nAttribute: %s\nAccessTransformer Config: %s".formatted(attribute, atFile)).severity(Severity.ERROR).solution("Ensure your AccessTransformers configuration file exists.").solution("Do not use AccessTransformers if you do not need to.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    RuntimeException accessTransformerConfigUnreadable(Throwable e, Attribute<Boolean> attribute, File atFile) {
        return this.getReporter().throwing(e, this.id("access-transformer-config-unreadable", "Access transformer config file not read"), spec -> spec.details("The access transformer cannot transform the input artifact because the configuration file could not be read.\nThis may be due to insufficient file permissions or a corrupted file.\nAttribute: %s\nAccessTransformer Config: %s".formatted(attribute, atFile)).severity(Severity.ERROR).solution("Ensure you (and/or Gradle) have proper read/write permissions to the AccessTransformer config file.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    RuntimeException accessTransformerConfigEmpty(Exception e, Attribute<Boolean> attribute, File atFile) {
        return this.getReporter().throwing((Throwable)e, this.id("access-transformer-config-empty", "Access transformer config missing or empty"), spec -> spec.details("The access transformer cannot transform the input artifact because the configuration file is empty or blank.\nAttribute: %s\nAccessTransformer Config: %s".formatted(attribute, atFile)).severity(Severity.ERROR).solution("Ensure your AccessTransformers configuration file contains definitions to be used.").solution("Do not use AccessTransformers if you do not need to.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    void reportAccessTransformerCannotValidateOutput(Exception e, File inJar, File atFile, File outJar, File logFile) {
        this.getLogger().warn("WARNING: Access transformer completed, but failed to validate the output. Output jar: {}", (Object)outJar.getAbsolutePath());
        this.getReporter().report(this.id("access-transformer-output-validation-failed", "Failed to validate the access transformed output"), spec -> spec.details("The access transformer completed the transformation, but failed to validate the output.\nWhile the output JAR may have been created successfully, it cannot be determined if any transformations were made.\nThis could potentially be caused the lack of read/write permissions in the build folder.\nInput Jar: %s\nAccessTransformer Config: %s\nOutput Jar: %s\nExecution Log: %s".formatted(inJar, atFile, outJar, logFile)).severity(Severity.WARNING).withException((Throwable)e).fileLocation(atFile.getAbsolutePath()).solution("Ensure you (and/or Gradle) have proper read/write permissions to the build folder.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    RuntimeException accessTransformerCannotWriteOutput(Exception e, Path output) {
        return this.getReporter().throwing((Throwable)e, this.id("access-transformer-output-write-failed", "Failed to write the access transformed output"), spec -> spec.details("The access transformer completed the transformation, but failed to write the output to Gradle.\nThis could potentially be caused the lack of read/write permissions in the build folder or Gradle caches (`~/.gradle`).\nTransform action output: %s".formatted(output.toAbsolutePath())).severity(Severity.ERROR).solution("Ensure you (and/or Gradle) have proper read/write permissions to the build folder.").solution("Ensure you (and/or Gradle) have proper read/write permissions to the Gradle caches (`~/.gradle`).").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    void reportAccessTransformerOutputIdentical(File inJar, File atFile, File outJar, File logFile) {
        this.getLogger().warn("WARNING: Access transformer completed, but the output bytes are the same as the input. Output jar: {}", (Object)outJar.getAbsolutePath());
        this.getReporter().report(this.id("access-transformer-output-identical", "Access transformer output identical to input"), spec -> spec.details("The access transformer completed the transformation, but the output bytes are the same as the input.\nThis could potentially be caused by an empty or invalid access transformer configuration.\nInput Jar: %s\nAccessTransformer Config: %s\nOutput Jar: %s\nExecution Log: %s".formatted(inJar, atFile, outJar, logFile)).severity(Severity.WARNING).fileLocation(atFile.getAbsolutePath()).solution("Check your access transformer configuration file and ensure the correct members are stated.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }

    RuntimeException accessTransformerFailed(RuntimeException e, File inJar, File atFile, File logFile) {
        return this.getReporter().throwing((Throwable)e, this.id("access-transformer-failed", "Access transformer failed"), spec -> spec.details("The access transformer failed to apply the transformations.\nThis could potentially be caused by an invalid access transformer configuration.\nInput Jar: %s\nAccessTransformer Config: %s\nExecution Log: %s".formatted(inJar, atFile, logFile)).severity(Severity.ERROR).fileLocation(atFile.getAbsolutePath()).solution("Check your access transformer configuration file and ensure it is valid.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server."));
    }
}

