/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.artifactural.gradle;

import net.minecraftforge.artifactural.api.artifact.ArtifactIdentifier;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.repositories.ArtifactResolutionDetails;
import org.gradle.api.internal.artifacts.repositories.ContentFilteringRepository;
import org.gradle.api.internal.attributes.ImmutableAttributes;

public class RepositoryContentUtils {
    public static boolean contentFilterExcludes(ArtifactRepository repository, ArtifactIdentifier artifact) {
        if (repository instanceof ContentFilteringRepository) {
            Action contentFilter = ((ContentFilteringRepository)repository).getContentFilter();
            ContentResolutionTracker details = new ContentResolutionTracker(artifact);
            contentFilter.execute((Object)details);
            return details.wontBeFound;
        }
        return false;
    }

    private static class ContentResolutionTracker
    implements ArtifactResolutionDetails {
        private final ModuleIdentifier moduleIdentifier;
        private final ModuleComponentIdentifier moduleComponentIdentifier;
        private boolean wontBeFound;

        ContentResolutionTracker(final ArtifactIdentifier artifact) {
            this.moduleIdentifier = new ModuleIdentifier(){

                public String getGroup() {
                    return artifact.getGroup();
                }

                public String getName() {
                    return artifact.getName();
                }
            };
            this.moduleComponentIdentifier = new ModuleComponentIdentifier(){

                public String getGroup() {
                    return this.getModuleIdentifier().getGroup();
                }

                public String getModule() {
                    return this.getModuleIdentifier().getName();
                }

                public String getVersion() {
                    return artifact.getVersion();
                }

                public ModuleIdentifier getModuleIdentifier() {
                    return this.getModuleId();
                }

                public String getDisplayName() {
                    return artifact.toString();
                }
            };
        }

        public ModuleIdentifier getModuleId() {
            return this.moduleIdentifier;
        }

        public ModuleComponentIdentifier getComponentId() {
            return this.moduleComponentIdentifier;
        }

        public AttributeContainer getConsumerAttributes() {
            return ImmutableAttributes.EMPTY;
        }

        public String getConsumerName() {
            return "artifacturalContentConsumer";
        }

        public boolean isVersionListing() {
            return this.moduleComponentIdentifier == null;
        }

        public void notFound() {
            this.wontBeFound = true;
        }
    }
}

