/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.artifactural.base.repository;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraftforge.artifactural.api.artifact.Artifact;
import net.minecraftforge.artifactural.api.repository.ArtifactProvider;

public class ArtifactProviderBuilder<S, I>
implements ArtifactProvider.Builder<S, I> {
    private final Function<S, I> mapper;
    private final Set<Predicate<I>> filters = new HashSet<Predicate<I>>();

    public static <I> ArtifactProviderBuilder<I, I> begin(Class<I> type) {
        return new ArtifactProviderBuilder(Function.identity());
    }

    private ArtifactProviderBuilder(Function<S, I> mapper) {
        this.mapper = mapper;
    }

    @Override
    public ArtifactProvider.Builder<S, I> filter(Predicate<I> filter) {
        this.filters.add(filter);
        return this;
    }

    @Override
    public <D> ArtifactProvider.Builder<S, D> mapInfo(Function<I, D> mapper) {
        if (this.filters.isEmpty()) {
            return new ArtifactProviderBuilder<S, D>(this.mapper.andThen(mapper));
        }
        return new ArtifactProviderBuilder<Object, Object>(info -> {
            I localInfo = this.mapper.apply(info);
            if (localInfo == null) {
                return null;
            }
            for (Predicate<I> filter : this.filters) {
                if (filter.test(localInfo)) continue;
                return null;
            }
            return mapper.apply(localInfo);
        });
    }

    @Override
    public ArtifactProvider.Builder.Complete<S, I> provide(ArtifactProvider<I> provider) {
        return new Complete(this.mapper).provide(provider);
    }

    private static class Complete<S, I>
    implements ArtifactProvider.Builder.Complete<S, I> {
        private final Set<ArtifactProvider<I>> providers = new HashSet<ArtifactProvider<I>>();
        private final Function<S, I> mapper;

        private Complete(Function<S, I> mapper) {
            this.mapper = mapper;
        }

        @Override
        public ArtifactProvider.Builder.Complete<S, I> provide(ArtifactProvider<I> provider) {
            this.providers.add(provider);
            return this;
        }

        @Override
        public Artifact getArtifact(S info) {
            I localInfo = this.mapper.apply(info);
            if (localInfo == null) {
                return Artifact.none();
            }
            for (ArtifactProvider<I> provider : this.providers) {
                Artifact artifact = provider.getArtifact(localInfo);
                if (!artifact.isPresent()) continue;
                return artifact;
            }
            return Artifact.none();
        }
    }
}

