/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.artifactural.base.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraftforge.artifactural.api.artifact.Artifact;
import net.minecraftforge.artifactural.api.artifact.ArtifactIdentifier;
import net.minecraftforge.artifactural.api.artifact.ArtifactMetadata;
import net.minecraftforge.artifactural.api.artifact.ArtifactType;
import net.minecraftforge.artifactural.api.artifact.MissingArtifactException;
import net.minecraftforge.artifactural.api.cache.ArtifactCache;
import net.minecraftforge.artifactural.api.transform.ArtifactTransformer;
import net.minecraftforge.artifactural.base.artifact.StreamableArtifact;

public abstract class ArtifactCacheBase
implements ArtifactCache {
    Artifact.Cached doStore(File path, Artifact artifact) {
        return ArtifactCacheBase.wrap(StreamableArtifact.ofStreamable(artifact.getIdentifier(), artifact.getType(), () -> this.stream(path, artifact)).withMetadata(artifact.getMetadata()), path);
    }

    private InputStream stream(File path, Artifact artifact) throws IOException {
        if (!path.exists()) {
            int read;
            path.getParentFile().mkdirs();
            path.createNewFile();
            FileOutputStream fos = new FileOutputStream(path);
            InputStream is = artifact.openStream();
            byte[] bytes = new byte[256];
            while ((read = is.read(bytes)) > 0) {
                fos.write(bytes, 0, read);
            }
            fos.close();
            is.close();
        }
        return new FileInputStream(path);
    }

    public static Artifact.Cached wrap(final Artifact artifact, final File file) {
        return new Artifact.Cached(){

            @Override
            public ArtifactIdentifier getIdentifier() {
                return artifact.getIdentifier();
            }

            @Override
            public ArtifactMetadata getMetadata() {
                return artifact.getMetadata();
            }

            @Override
            public ArtifactType getType() {
                return artifact.getType();
            }

            @Override
            public Artifact withMetadata(ArtifactMetadata metadata) {
                return artifact.withMetadata(metadata);
            }

            @Override
            public Artifact apply(ArtifactTransformer transformer) {
                return artifact.apply(transformer);
            }

            @Override
            public Artifact.Cached cache(ArtifactCache cache) {
                return artifact.cache(cache);
            }

            @Override
            public boolean isPresent() {
                return artifact.isPresent();
            }

            @Override
            public InputStream openStream() throws IOException, MissingArtifactException {
                return artifact.openStream();
            }

            @Override
            public File asFile() throws IOException, MissingArtifactException {
                if (!file.exists()) {
                    artifact.openStream().close();
                }
                return file;
            }

            @Override
            public File getFileLocation() throws MissingArtifactException {
                return file;
            }

            public String toString() {
                return "wrapped(" + artifact + ", " + file + ")";
            }
        };
    }
}

