/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.artifactural.base.artifact;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.minecraftforge.artifactural.api.artifact.Artifact;
import net.minecraftforge.artifactural.api.artifact.ArtifactIdentifier;
import net.minecraftforge.artifactural.api.artifact.ArtifactMetadata;
import net.minecraftforge.artifactural.api.artifact.ArtifactType;
import net.minecraftforge.artifactural.api.artifact.MissingArtifactException;
import net.minecraftforge.artifactural.api.artifact.Streamable;
import net.minecraftforge.artifactural.base.artifact.ArtifactBase;
import net.minecraftforge.artifactural.base.artifact.SimpleArtifactMetadata;

public class StreamableArtifact
extends ArtifactBase {
    private final Streamable streamable;

    public static Artifact ofFile(ArtifactIdentifier identifier, ArtifactType type, File file) {
        return new StreamableFileArtifact(identifier, type, file);
    }

    public static Artifact ofURL(ArtifactIdentifier identifier, ArtifactType type, URL url) {
        return new StreamableArtifact(identifier, type, url::openStream);
    }

    public static Artifact ofBytes(ArtifactIdentifier identifier, ArtifactType type, byte[] bytes) {
        return new StreamableArtifact(identifier, type, () -> new ByteArrayInputStream(bytes));
    }

    public static Artifact ofStreamable(ArtifactIdentifier identifier, ArtifactType type, Streamable streamable) {
        return new StreamableArtifact(identifier, type, streamable);
    }

    private StreamableArtifact(ArtifactIdentifier identifier, ArtifactType type, Streamable streamable) {
        this(identifier, type, new SimpleArtifactMetadata(), streamable);
    }

    private StreamableArtifact(ArtifactIdentifier identifier, ArtifactType type, ArtifactMetadata metadata, Streamable streamable) {
        super(identifier, type, metadata);
        this.streamable = streamable;
    }

    @Override
    public Artifact withMetadata(ArtifactMetadata metadata) {
        return new StreamableArtifact(this.getIdentifier(), this.getType(), metadata, this.streamable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isPresent() {
        try (InputStream is = this.openStream();){
            is.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.streamable.openStream();
    }

    private static class StreamableFileArtifact
    extends StreamableArtifact
    implements Artifact.Cached {
        private final File file;

        private StreamableFileArtifact(ArtifactIdentifier identifier, ArtifactType type, File file) {
            super(identifier, type, () -> new FileInputStream(file));
            this.file = file;
        }

        @Override
        public File asFile() throws MissingArtifactException {
            return this.file;
        }

        @Override
        public File getFileLocation() throws MissingArtifactException {
            return this.file;
        }

        @Override
        public String toString() {
            return "StreamableFileArtifact(" + this.file + ")";
        }
    }
}

