/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.artifactural.base.artifact;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.artifactural.api.artifact.ArtifactMetadata;

public class SimpleArtifactMetadata
implements ArtifactMetadata {
    private final List<Entry> entries = new LinkedList<Entry>();
    private String hash = null;

    public SimpleArtifactMetadata() {
    }

    private SimpleArtifactMetadata(SimpleArtifactMetadata parent, Entry entry) {
        this.entries.addAll(parent.entries);
        this.entries.add(entry);
    }

    @Override
    public ArtifactMetadata with(String key, String value) {
        return new SimpleArtifactMetadata(this, new Entry(key, value));
    }

    @Override
    public String getHash() {
        if (this.hash != null) {
            return this.hash;
        }
        try {
            String str = this.entries.stream().map(Entry::toString).collect(Collectors.joining("\n"));
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] hashBytes = digest.digest(str.getBytes());
            StringBuilder hashBuilder = new StringBuilder();
            for (byte b : hashBytes) {
                hashBuilder.append(String.format("%02x", b));
            }
            this.hash = hashBuilder.toString();
            return this.hash;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return "SimpleArtifactMetadata(" + this.entries.toString() + ", " + this.getHash() + ")";
    }

    private static class Entry {
        private final String key;
        private final String value;

        private Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return '[' + this.key + ',' + this.value + ']';
        }
    }
}

