/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.artifactural.base.artifact;

import net.minecraftforge.artifactural.api.artifact.Artifact;
import net.minecraftforge.artifactural.api.artifact.ArtifactIdentifier;
import net.minecraftforge.artifactural.api.artifact.ArtifactMetadata;
import net.minecraftforge.artifactural.api.artifact.ArtifactType;
import net.minecraftforge.artifactural.api.cache.ArtifactCache;
import net.minecraftforge.artifactural.api.transform.ArtifactTransformer;

public abstract class ArtifactBase
implements Artifact {
    private final ArtifactIdentifier identifier;
    private final ArtifactType type;
    private final ArtifactMetadata metadata;

    public ArtifactBase(ArtifactIdentifier identifier, ArtifactType type, ArtifactMetadata metadata) {
        this.identifier = identifier;
        this.type = type;
        this.metadata = metadata;
    }

    @Override
    public ArtifactIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public ArtifactType getType() {
        return this.type;
    }

    @Override
    public ArtifactMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Artifact apply(ArtifactTransformer transformer) {
        if (!transformer.appliesTo(this)) {
            return this;
        }
        return transformer.transform(this);
    }

    @Override
    public Artifact.Cached cache(ArtifactCache cache) {
        return cache.store(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.identifier + ", " + (Object)((Object)this.type) + ", " + this.metadata;
    }
}

