/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.artifactural.api.artifact;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.minecraftforge.artifactural.api.artifact.ArtifactIdentifier;
import net.minecraftforge.artifactural.api.artifact.ArtifactMetadata;
import net.minecraftforge.artifactural.api.artifact.ArtifactType;
import net.minecraftforge.artifactural.api.artifact.Internal;
import net.minecraftforge.artifactural.api.artifact.MissingArtifactException;
import net.minecraftforge.artifactural.api.cache.ArtifactCache;
import net.minecraftforge.artifactural.api.transform.ArtifactTransformer;

public interface Artifact {
    public static Artifact none() {
        return Internal.NO_ARTIFACT;
    }

    public ArtifactIdentifier getIdentifier();

    public ArtifactMetadata getMetadata();

    public ArtifactType getType();

    public Artifact withMetadata(ArtifactMetadata var1);

    public Artifact apply(ArtifactTransformer var1);

    public Cached cache(ArtifactCache var1);

    default public Cached optionallyCache(ArtifactCache cache) {
        return this instanceof Cached ? (Cached)this : this.cache(cache);
    }

    public boolean isPresent();

    public InputStream openStream() throws IOException, MissingArtifactException;

    public static interface Cached
    extends Artifact {
        public File asFile() throws IOException, MissingArtifactException;

        public File getFileLocation() throws IOException, MissingArtifactException;
    }
}

