/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.testing.aggregate;

import javax.inject.Inject;
import net.minecraftforge.testing.aggregate.shadow.net.minecraftforge.gradleutils.shared.EnhancedProblems;
import org.gradle.api.Action;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.Severity;

abstract class AggregateTestProblems
extends EnhancedProblems {
    private static final long serialVersionUID = -7012782925643402023L;

    @Inject
    public AggregateTestProblems() {
        super("jvm-aggregate-test", "JVM Aggregate Testing");
    }

    void reportTestToolchainInaccessible(Exception e, String name) {
        this.report("test-toolchain-inaccessible", "Test Toolchain could not be accessed", (Action<? super ProblemSpec>)((Action)spec -> spec.details("The '%s' test suite's testing toolchain could not be accessed.\nWhile this is an internal Gradle property, it is used to avoid problems with the configuration cache.\nThe JVM Aggregate Testing plugin will continue to work, but it will not be compatible with the configuration cache.".formatted(name)).withException((Throwable)e).severity(Severity.WARNING).solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server.")));
    }

    void reportNotUsingJvmTestSuite() {
        this.report("jvm-test-suite-plugin-not-found", "JVM Test Suite plugin not found", (Action<? super ProblemSpec>)((Action)spec -> spec.details("The JVM Test Suite plugin was not found in this project.\nThe JVM Aggregate Testing uses implementation details from this plugin to stay compatible with the configuration cache.\nConsider using the JVM Test Suite plugin in your project, as aggregate testing is configured to work with it.").severity(Severity.ADVICE).solution("Apply the `jvm-test-suite` plugin to your project.").solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server.")));
    }
}

