/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.testing.aggregate;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import javax.inject.Inject;
import net.minecraftforge.testing.aggregate.AggregateTestExtensionInternal;
import net.minecraftforge.testing.aggregate.AggregateTestImpl;
import net.minecraftforge.testing.aggregate.AggregateTestProblems;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.JvmTestSuiteTarget;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.testing.base.TestingExtension;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

abstract class AggregateTestExtensionImpl
implements AggregateTestExtensionInternal {
    private final Map<String, List<Integer>> jvms = new TreeMap(Comparator.naturalOrder());
    private final AggregateTestProblems problems = (AggregateTestProblems)this.getObjects().newInstance(AggregateTestProblems.class, new Object[0]);

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProjectLayout getLayout();

    @Inject
    protected abstract JavaToolchainService getJavaToolchains();

    @Inject
    public AggregateTestExtensionImpl(Project project) {
        project.afterEvaluate(this::finish);
    }

    @Override
    public @UnmodifiableView Map<String, List<Integer>> getJvms() {
        return Collections.unmodifiableMap(this.jvms);
    }

    @Override
    public void jvms(Map<? extends CharSequence, List<Integer>> jvms) {
        for (Map.Entry<? extends CharSequence, List<Integer>> entry : jvms.entrySet()) {
            this.jvms.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public void setJvms(Map<? extends CharSequence, List<Integer>> jvms) {
        this.jvms.clear();
        this.jvms(jvms);
    }

    private void finish(Project project) {
        if (project.getPluginManager().hasPlugin("jvm-test-suite")) {
            TestingExtension testing = (TestingExtension)project.getExtensions().getByType(TestingExtension.class);
            NamedDomainObjectSet suites = testing.getSuites().withType(JvmTestSuite.class);
            for (JvmTestSuite suite : suites) {
                Function<Test, Provider<TestFramework>> testToolchain = this.getTestToolchain(suite);
                for (JvmTestSuiteTarget target : suite.getTargets()) {
                    this.configure(project, (Test)target.getTestTask().get(), testToolchain);
                }
            }
        } else {
            this.problems.reportNotUsingJvmTestSuite();
            for (Test test : project.getTasks().withType(Test.class)) {
                this.configure(project, test, null);
            }
        }
    }

    @Nullable
    private Function<Test, Provider<TestFramework>> getTestToolchain(JvmTestSuite suite) {
        try {
            Property testToolchain = (Property)InvokerHelper.getProperty((Object)suite, (String)"testToolchain");
            return test -> testToolchain.map(t -> t.createTestFramework(test));
        }
        catch (Exception e) {
            this.problems.reportTestToolchainInaccessible(e, suite.getName());
            return null;
        }
    }

    private void configure(Project project, Test test, @Nullable Function<Test, Provider<TestFramework>> testToolchain) {
        if (this.jvms.isEmpty()) {
            return;
        }
        TaskProvider testAll = project.getTasks().register("jvmAggregate" + StringGroovyMethods.capitalize((CharSequence)test.getName()), AggregateTestImpl.class, task -> task.setGroup("verification"));
        for (Map.Entry<String, List<Integer>> entry : this.jvms.entrySet()) {
            String vendor = entry.getKey();
            List<Integer> versions = entry.getValue();
            for (int version : versions) {
                Provider output = this.getLayout().getBuildDirectory().dir("aggregate-test-results" + "/%s-%d".formatted(vendor, version)).map(this.problems.ensureFileLocation());
                TaskProvider<Test> task2 = this.register(project, testToolchain, test, vendor, version, (Provider<Directory>)output);
                testAll.configure(testAllTask -> {
                    testAllTask.getInputs().dir((Object)output);
                    testAllTask.dependsOn(new Object[]{task2});
                });
            }
        }
    }

    private TaskProvider<Test> register(Project project, @Nullable Function<Test, Provider<TestFramework>> testToolchain, Test test, String vendor, int version, Provider<Directory> output) {
        JvmVendorSpec vendorSpec = JvmVendorSpec.of((String)vendor);
        return project.getTasks().register("testUsing" + StringGroovyMethods.capitalize((CharSequence)vendor) + version, Test.class, task -> {
            String description = test.getDescription();
            task.setDescription(description != null ? "%s (using %s %s)".formatted(description, vendorSpec, version) : "Runs '%s' using %s %s".formatted(test.getName(), vendorSpec, version));
            if (testToolchain != null) {
                task.getTestFrameworkProperty().set((Provider)testToolchain.apply((Test)task));
            } else {
                task.getTestFrameworkProperty().set((Provider)test.getTestFrameworkProperty());
                task.notCompatibleWithConfigurationCache("JVM-specific tests need the test framework from the parent test task, which cannot be serialized.");
            }
            task.setClasspath(test.getClasspath());
            task.setTestClassesDirs(test.getTestClassesDirs());
            task.getJavaLauncher().set(this.getJavaToolchains().launcherFor(spec -> {
                spec.getVendor().set((Object)vendorSpec);
                spec.getLanguageVersion().set((Object)JavaLanguageVersion.of((int)version));
                spec.getImplementation().set((Object)JvmImplementation.VENDOR_SPECIFIC);
            }));
            task.reports(reports -> {
                reports.getHtml().getOutputLocation().set(output);
                reports.getJunitXml().getOutputLocation().set(output);
            });
        });
    }
}

