/*
 * Copyright (c) Forge Development LLC
 * SPDX-License-Identifier: LGPL-2.1-only
 */
package net.minecraftforge.testing.aggregate;

import net.minecraftforge.gradleutils.shared.EnhancedPlugin;
import org.gradle.api.Project;

import javax.inject.Inject;

abstract class AggregateTestPlugin extends EnhancedPlugin<Project> {
    static final String NAME = "jvm-aggregate-test";
    static final String DISPLAY_NAME = "JVM Aggregate Testing";

    @Inject
    public AggregateTestPlugin() {
        super(NAME, DISPLAY_NAME);
    }

    @Override
    public void setup(Project project) {
        project.getExtensions().create(AggregateTestExtension.NAME, AggregateTestExtensionImpl.class);
    }
}
