/*
 * Copyright (c) Forge Development LLC
 * SPDX-License-Identifier: LGPL-2.1-only
 */
package net.minecraftforge.testing.aggregate;

import org.jetbrains.annotations.UnmodifiableView;

import java.util.List;
import java.util.Map;

public sealed interface AggregateTestExtension permits AggregateTestExtensionInternal {
    String NAME = "aggregateTesting";

    @UnmodifiableView Map<String, List<Integer>> getJvms();

    void jvms(Map<? extends CharSequence, List<Integer>> jvms);

    void setJvms(Map<? extends CharSequence, List<Integer>> jvms);
}
