/*
 * Copyright (c) Forge Development LLC
 * SPDX-License-Identifier: LGPL-2.1-only
 */
package net.minecraftforge.testing.aggregate;

import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputFile;

public sealed interface AggregateTest extends Task permits AggregateTestInternal {
    String TEST_RESULTS_DIRECTORY = "aggregate-test-results";

    @InputDirectory DirectoryProperty getInput();

    @OutputFile RegularFileProperty getOutput();
}
