/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.testing.aggregate.shadow.net.minecraftforge.gradleutils.shared.shadow.net.minecraftforge.util.hash;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import net.minecraftforge.testing.aggregate.shadow.net.minecraftforge.gradleutils.shared.shadow.net.minecraftforge.util.hash.HashUtils;

public enum HashFunction {
    MD5("md5", 32),
    SHA1("SHA-1", 40),
    SHA256("SHA-256", 64),
    SHA512("SHA-512", 128);

    private final String algo;
    private final String pad;
    private final String ext;
    private Boolean supported;
    private static final byte[] HEX_ARRAY;

    private HashFunction(String algo, int length) {
        this.algo = algo;
        this.pad = String.format(Locale.ENGLISH, "%0" + length + "d", 0);
        this.ext = this.name().toLowerCase(Locale.ENGLISH);
    }

    public String extension() {
        return this.ext;
    }

    public static HashFunction find(String name) {
        String cleaned = name.toUpperCase(Locale.ENGLISH);
        for (HashFunction func : HashFunction.values()) {
            if (!cleaned.equals(func.name())) continue;
            return func;
        }
        return null;
    }

    public static HashFunction findByHash(String hash) {
        int len = hash.length();
        for (HashFunction func : HashFunction.values()) {
            if (func.pad.length() != len) continue;
            return func;
        }
        return null;
    }

    public boolean supported() {
        if (this.supported == null) {
            try {
                MessageDigest.getInstance(this.algo);
                this.supported = true;
            }
            catch (NoSuchAlgorithmException e) {
                this.supported = false;
            }
        }
        return this.supported;
    }

    public MessageDigest get() {
        try {
            return MessageDigest.getInstance(this.algo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String hash(File file) throws IOException {
        try (FileInputStream fin = new FileInputStream(file);){
            String string = this.hash(fin);
            return string;
        }
    }

    public String sneakyHash(File file) {
        try {
            return this.hash(file);
        }
        catch (IOException e) {
            return (String)HashUtils.sneak(e);
        }
    }

    public String hash(File ... files) throws IOException {
        return this.hash(Arrays.asList(files));
    }

    public String sneakyHash(File ... files) {
        try {
            return this.hash(Arrays.asList(files));
        }
        catch (IOException e) {
            return (String)HashUtils.sneak(e);
        }
    }

    public String hash(Iterable<File> files) throws IOException {
        MessageDigest hash = this.get();
        byte[] buf = new byte[1024];
        for (File file : files) {
            if (!file.exists()) continue;
            FileInputStream fin = new FileInputStream(file);
            Throwable throwable = null;
            try {
                int count = -1;
                while ((count = fin.read(buf)) != -1) {
                    hash.update(buf, 0, count);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fin == null) continue;
                if (throwable != null) {
                    try {
                        fin.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fin.close();
            }
        }
        return this.pad(new BigInteger(1, hash.digest()).toString(16));
    }

    public String hash(String data) {
        return this.hash(data == null ? new byte[]{} : data.getBytes(StandardCharsets.UTF_8));
    }

    public String hash(InputStream stream) throws IOException {
        MessageDigest hash = this.get();
        byte[] buf = new byte[1024];
        int count = -1;
        while ((count = stream.read(buf)) != -1) {
            hash.update(buf, 0, count);
        }
        return this.pad(new BigInteger(1, hash.digest()).toString(16));
    }

    public String hash(byte[] data) {
        return this.pad(new BigInteger(1, this.get().digest(data)).toString(16));
    }

    public String pad(String hash) {
        return (this.pad + hash).substring(hash.length());
    }

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        byte[] hexChars = new byte[bytes.length * 3 - 1];
        int k = 0;
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[k++] = HEX_ARRAY[v >>> 4];
            hexChars[k++] = HEX_ARRAY[v & 0xF];
            if (j >= bytes.length - 1) continue;
            hexChars[k++] = 32;
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    static {
        HEX_ARRAY = "0123456789abcdef".getBytes(StandardCharsets.UTF_8);
    }
}

