/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraftforge.accesstransformer.AccessTransformerEngine;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class TransformerProcessor {
    private static final Logger LOGGER;
    private static final Marker AXFORM_MARKER;

    public static void main(String ... args) {
        List<Path> atFilePaths;
        Path outputJarPath;
        Path inputJarPath;
        OptionParser optionParser = new OptionParser();
        ArgumentAcceptingOptionSpec<Path> inputJar = optionParser.accepts("inJar", "Input JAR file to apply transformation to").withRequiredArg().withValuesConvertedBy(new PathConverter(PathProperties.FILE_EXISTING)).required();
        ArgumentAcceptingOptionSpec<Path> atFiles = optionParser.acceptsAll(TransformerProcessor.list("atfile", "atFile"), "Access Transformer File").withRequiredArg().withValuesConvertedBy(new PathConverter(PathProperties.FILE_EXISTING)).required();
        ArgumentAcceptingOptionSpec<Path> outputJar = optionParser.accepts("outJar", "Output JAR file").withRequiredArg().withValuesConvertedBy(new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec<String> logFilePath = optionParser.accepts("logFile", "Log file for logging").withRequiredArg();
        try {
            OptionSet optionSet = optionParser.parse(args);
            String logFile = (String)logFilePath.value(optionSet);
            if (logFile != null) {
                LoggerContext logcontext = LoggerContext.getContext(false);
                Configuration configuration = logcontext.getConfiguration();
                FileAppender fileAppender = ((FileAppender.Builder)((AbstractAppender.Builder)((FileAppender.Builder)((AbstractAppender.Builder)FileAppender.newBuilder()).setName("logfile")).withFileName(logFile)).setLayout(configuration.getAppender("SysErr").getLayout())).build();
                fileAppender.start();
                configuration.addAppender(fileAppender);
                configuration.getRootLogger().addAppender(fileAppender, Level.DEBUG, null);
                logcontext.updateLoggers();
                LOGGER.info(AXFORM_MARKER, "Writing debug log file {}", (Object)logFile);
            }
            inputJarPath = ((Path)inputJar.value(optionSet)).toAbsolutePath();
            String s = inputJarPath.getFileName().toString();
            outputJarPath = (Path)outputJar.value(optionSet);
            outputJarPath = outputJarPath == null ? inputJarPath.resolveSibling(s.substring(0, s.length() - 4) + "-new.jar") : outputJarPath.toAbsolutePath();
            atFilePaths = atFiles.values(optionSet).stream().map(Path::toAbsolutePath).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error(AXFORM_MARKER, "Option Parsing Error", (Throwable)e);
            return;
        }
        LOGGER.info(AXFORM_MARKER, "Access Transformer processor running version {}", (Object)TransformerProcessor.class.getPackage().getImplementationVersion());
        LOGGER.info(AXFORM_MARKER, "Command line arguments {}", (Object)Arrays.asList(args));
        LOGGER.info(AXFORM_MARKER, "Reading from {}", (Object)inputJarPath);
        LOGGER.info(AXFORM_MARKER, "Writing to {}", (Object)outputJarPath);
        atFilePaths.forEach(path -> LOGGER.info(AXFORM_MARKER, "Transformer file {}", path));
        try {
            LOGGER.warn("Found existing output jar {}, overwriting", (Object)outputJarPath);
            Files.deleteIfExists(outputJarPath);
        }
        catch (IOException e) {
            LOGGER.error(AXFORM_MARKER, "Deleting existing out JAR", (Throwable)e);
            TransformerProcessor.sneak(e);
        }
        TransformerProcessor.processJar(inputJarPath, outputJarPath, atFilePaths);
        LOGGER.info(AXFORM_MARKER, "JAR transformation complete {}", (Object)outputJarPath);
    }

    private static List<String> list(String ... vars) {
        return Arrays.asList(vars);
    }

    private static void processJar(Path inputJar, Path outputJarPath, List<Path> atFilePaths) {
        atFilePaths.forEach(path -> {
            AccessTransformerEngine.INSTANCE.addResource((Path)path, path.getFileName().toString());
            LOGGER.debug(AXFORM_MARKER, "Loaded access transformer file {}", path);
        });
        Path parent = outputJarPath.getParent();
        if (parent != null & !Files.exists(parent, new LinkOption[0])) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error(AXFORM_MARKER, "Creating Parents", (Throwable)e);
                TransformerProcessor.sneak(e);
            }
        }
        URI toUri = outputJarPath.toUri();
        URI outJarURI = URI.create("jar:" + toUri.toASCIIString());
        try (FileSystem outJar = FileSystems.newFileSystem(outJarURI, new HashMap<String, String>(){
            {
                this.put("create", "true");
            }
        });){
            try (FileSystem jarFile = FileSystems.newFileSystem(inputJar, ClassLoader.getSystemClassLoader());){
                Files.walk(StreamSupport.stream(jarFile.getRootDirectories().spliterator(), false).findFirst().orElseThrow(() -> new IllegalArgumentException("The JAR has no root?!")), new FileVisitOption[0]).forEach(path -> {
                    Path outPath = outJar.getPath(path.toAbsolutePath().toString(), new String[0]);
                    if (path.getNameCount() > 0 && String.valueOf(path.getFileName()).endsWith(".class")) {
                        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                            ClassReader classReader = new ClassReader(is);
                            ClassNode cn = new ClassNode();
                            classReader.accept(cn, 0);
                            Type type = Type.getType('L' + cn.name.replaceAll("\\.", "/") + ';');
                            if (AccessTransformerEngine.INSTANCE.handlesClass(type)) {
                                LOGGER.debug(AXFORM_MARKER, "Transforming class {}", (Object)type);
                                AccessTransformerEngine.INSTANCE.transform(cn, type);
                                ClassWriter cw = new ClassWriter(327680);
                                cn.accept(cw);
                                Files.write(outPath, cw.toByteArray(), new OpenOption[0]);
                            } else {
                                LOGGER.debug(AXFORM_MARKER, "Skipping {}", (Object)type);
                                Files.copy(path, outPath, new CopyOption[0]);
                            }
                        }
                        catch (IOException e) {
                            LOGGER.error(AXFORM_MARKER, "Reading {}", path, (Object)e);
                            TransformerProcessor.sneak(e);
                        }
                    } else if (!Files.exists(outPath, new LinkOption[0])) {
                        try {
                            Files.copy(path, outPath, new CopyOption[0]);
                        }
                        catch (IOException e) {
                            LOGGER.error(AXFORM_MARKER, "Copying {}", path, (Object)e);
                            TransformerProcessor.sneak(e);
                        }
                    }
                });
            }
            catch (IOException e) {
                LOGGER.error(AXFORM_MARKER, "Reading JAR", (Throwable)e);
                TransformerProcessor.sneak(e);
            }
        }
        catch (IOException e) {
            LOGGER.error(AXFORM_MARKER, "Writing JAR", (Throwable)e);
            TransformerProcessor.sneak(e);
        }
    }

    private static <R, E extends Throwable> R sneak(Throwable t) throws E {
        throw t;
    }

    static {
        Configurator.initialize("", "atlog4j2.xml");
        LOGGER = LogManager.getLogger();
        AXFORM_MARKER = MarkerManager.getMarker("AXFORM");
    }
}

