/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformer.service;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.INameMappingService;
import net.minecraftforge.accesstransformer.INameHandler;

public class ServiceNameHandler
implements INameHandler {
    private final String origin;
    private final String target;

    public ServiceNameHandler(String origin, String target) {
        this.origin = origin;
        this.target = target;
    }

    String translate(INameMappingService.Domain domain, String origin) {
        return Launcher.INSTANCE.environment().findNameMapping(this.target).map(f -> (String)f.apply(domain, origin)).orElse(origin);
    }

    @Override
    public String translateClassName(String className) {
        return this.translate(INameMappingService.Domain.CLASS, className);
    }

    @Override
    public String translateFieldName(String fieldName) {
        return this.translate(INameMappingService.Domain.FIELD, fieldName);
    }

    @Override
    public String translateMethodName(String methodName) {
        return this.translate(INameMappingService.Domain.METHOD, methodName);
    }

    public String toString() {
        return "Service NameHandler from " + this.origin + " to " + this.target;
    }
}

