/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformer;

import java.util.Objects;
import java.util.Set;
import net.minecraftforge.accesstransformer.AccessTransformer;
import net.minecraftforge.accesstransformer.TargetType;
import org.objectweb.asm.Type;

public abstract class Target<T> {
    private final String className;
    private final Type type;

    public Target(String className) {
        this.className = className.replace('.', '/');
        this.type = Type.getType('L' + className + ';');
    }

    public TargetType getType() {
        return TargetType.CLASS;
    }

    public String getClassName() {
        return this.className;
    }

    public final Type getASMType() {
        return this.type;
    }

    public String toString() {
        return Objects.toString(this.className) + ' ' + Objects.toString((Object)this.getType());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Target)) {
            return false;
        }
        return Objects.equals(this.className, ((Target)obj).className) && Objects.equals((Object)this.getType(), (Object)((Target)obj).getType());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClassName(), this.getType(), "CLASS"});
    }

    public abstract String targetName();

    public abstract void apply(T var1, AccessTransformer.Modifier var2, AccessTransformer.FinalState var3, Set<String> var4);
}

