/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformers.gradle.shadow.net.minecraftforge.gradleutils.shared;

import groovy.lang.Closure;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraftforge.accesstransformers.gradle.shadow.net.minecraftforge.gradleutils.shared.Closures;
import org.gradle.api.Action;
import org.jetbrains.annotations.Nullable;

public class Lazy<T>
implements Supplier<T>,
Callable<T> {
    protected final Closure<T> closure;
    @Nullable
    protected T value;

    public static <T> Lazy<T> simple(Callable<T> callable) {
        return Lazy.simple(Closures.callable(callable));
    }

    public static <T> Lazy<T> simple(Closure<T> closure) {
        return new Lazy<T>(closure);
    }

    public static <T> Actionable<T> actionable(Callable<T> callable) {
        return Lazy.actionable(Closures.callable(callable));
    }

    public static <T> Actionable<T> actionable(Closure<T> closure) {
        return new Actionable<T>(closure);
    }

    private Lazy(Closure<T> closure) {
        this.closure = closure;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public final void ifPresent(Action<? super T> action) {
        if (this.isPresent()) {
            action.execute(this.get());
        }
    }

    @Override
    public T get() {
        return this.value == null ? (this.value = Closures.invoke(this.closure)) : this.value;
    }

    @Override
    public T call() {
        return this.get();
    }

    public static final class Actionable<T>
    extends Lazy<T> {
        private boolean present = false;
        private Closure<T> modifications = Closures.unaryOperator(o -> {
            this.present = true;
            return o;
        });

        private Actionable(Closure<T> closure) {
            super(closure);
        }

        public void map(Action<? super T> action) {
            this.present = true;
            if (this.value != null) {
                action.execute(this.value);
            } else {
                this.modifications = this.modifications.andThen(Closures.unaryOperator(value -> {
                    action.execute(value);
                    return value;
                }));
            }
        }

        @Override
        public boolean isPresent() {
            return this.present;
        }

        public Actionable<T> copy() {
            Actionable<T> ret = new Actionable<T>(this.closure);
            ret.value = this.value;
            ret.present = this.present;
            ret.modifications = this.modifications;
            return ret;
        }

        @Override
        public T get() {
            return (T)(this.value == null ? (this.value = Closures.invoke(this.closure.andThen(this.modifications))) : this.value);
        }
    }
}

