/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformers.gradle.shadow.net.minecraftforge.gradleutils.shared;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.codehaus.groovy.reflection.ReflectionUtils;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.gradle.api.Action;
import org.jetbrains.annotations.UnknownNullability;

public final class Closures {
    private static final Object[] EMPTY_ARGS = new Object[0];

    public static <T> @UnknownNullability T invoke(@DelegatesTo(strategy=1) Closure closure, Object ... object) {
        closure.setDelegate(object[0]);
        closure.setResolveStrategy(1);
        return Closures.invokeInternal(closure, object);
    }

    public static <T> @UnknownNullability T invoke(Closure closure) {
        return Closures.invokeInternal(closure, EMPTY_ARGS);
    }

    private static <T> @UnknownNullability T invokeInternal(Closure closure, Object ... object) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(closure.getClass().getClassLoader());
        try {
            Object ret = closure.getMaximumNumberOfParameters() == 0 ? closure.call() : closure.call(object);
            Object object2 = ret != null ? ret : null;
            return (T)object2;
        }
        catch (InvokerInvocationException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public static <R> Closure<R> unaryOperator(UnaryOperator<R> function) {
        return Closures.unaryOperator(ReflectionUtils.getCallingClass(), function);
    }

    public static <R> Closure<R> unaryOperator(Object owner, UnaryOperator<R> function) {
        return Closures.function(owner, function);
    }

    public static <T, R> Closure<R> function(Function<? super T, ? extends R> function) {
        return Closures.function(ReflectionUtils.getCallingClass(), function);
    }

    public static <T, R> Closure<R> function(Object owner, Function<? super T, ? extends R> function) {
        return new Functional<T, R>(owner, function);
    }

    public static <R> Closure<R> supplier(Supplier<? extends R> supplier) {
        return Closures.supplier(ReflectionUtils.getCallingClass(), supplier);
    }

    public static <R> Closure<R> supplier(Object owner, Supplier<? extends R> supplier) {
        return Closures.callable(owner, supplier::get);
    }

    public static <R> Closure<R> callable(Callable<? extends R> callable) {
        return Closures.callable(ReflectionUtils.getCallingClass(), callable);
    }

    public static <R> Closure<R> callable(Object owner, Callable<? extends R> callable) {
        return new Supplying<R>(owner, callable);
    }

    public static <T> Closure<Void> action(Action<? super T> action) {
        return Closures.action(ReflectionUtils.getCallingClass(), action);
    }

    public static <T> Closure<Void> action(Object owner, Action<? super T> action) {
        return Closures.consumer(owner, arg_0 -> action.execute(arg_0));
    }

    public static <T> Action<T> toAction(Closure<?> closure) {
        return it -> Closures.invoke(closure, it);
    }

    public static <T> Closure<Void> consumer(Consumer<? super T> consumer) {
        return Closures.consumer(ReflectionUtils.getCallingClass(), consumer);
    }

    public static <T> Closure<Void> consumer(Object owner, Consumer<? super T> consumer) {
        return new Consuming<T>(owner, consumer);
    }

    public static Closure<Void> runnable(Runnable runnable) {
        return Closures.runnable(ReflectionUtils.getCallingClass(), runnable);
    }

    public static Closure<Void> runnable(Object owner, Runnable runnable) {
        return new Running(owner, runnable);
    }

    public static Closure<Void> empty() {
        return Closures.empty(ReflectionUtils.getCallingClass());
    }

    public static Closure<Void> empty(Object owner) {
        return new Empty(owner);
    }

    private Closures() {
    }

    private static final class Functional<T, R>
    extends Closure<R> {
        private static final long serialVersionUID = -8736820647200105725L;
        private final Function<? super T, ? extends R> function;

        private Functional(Object owner, Function<? super T, ? extends R> function) {
            super(owner, owner);
            this.function = function;
        }

        public R doCall(T object) {
            return this.function.apply(object);
        }
    }

    private static final class Supplying<R>
    extends Closure<R> {
        private static final long serialVersionUID = 1281109313872080614L;
        private final Callable<? extends R> supplier;

        private Supplying(Object owner, Callable<? extends R> supplier) {
            super(owner, owner);
            this.supplier = supplier;
        }

        public R doCall() throws Exception {
            return this.supplier.call();
        }
    }

    private static final class Consuming<T>
    extends Closure<Void> {
        private static final long serialVersionUID = 1165200476195312981L;
        private final Consumer<? super T> consumer;

        private Consuming(Object owner, Consumer<? super T> consumer) {
            super(owner, owner);
            this.consumer = consumer;
        }

        public Void doCall(T object) {
            this.consumer.accept(object);
            return null;
        }
    }

    private static final class Running
    extends Empty {
        private static final long serialVersionUID = -3453835628821302135L;
        private final Runnable runnable;

        private Running(Object owner, Runnable runnable) {
            super(owner);
            this.runnable = runnable;
        }

        @Override
        public Void doCall() {
            this.runnable.run();
            return super.doCall();
        }
    }

    private static class Empty
    extends Closure<Void> {
        private static final long serialVersionUID = 6072707343050307552L;

        private Empty(Object owner) {
            super(owner, owner);
        }

        public Void doCall() {
            return null;
        }
    }
}

