/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformers.gradle;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersContainer;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersExtensionInternal;
import net.minecraftforge.accesstransformers.gradle.Util;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyScopeConfiguration;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.jetbrains.annotations.Nullable;

abstract class AccessTransformersExtensionImpl
implements AccessTransformersExtensionInternal {
    private final Project project;
    @Nullable
    private AccessTransformersContainer container;

    @Inject
    public AccessTransformersExtensionImpl(Project project) {
        this.project = project;
        project.afterEvaluate(AccessTransformersExtensionImpl::finish);
    }

    private static void finish(Project project) {
        NamedDomainObjectProvider c;
        ConfigurationContainer configurations = project.getConfigurations();
        try {
            c = configurations.dependencyScope("accessTransformersDependencyConstraints", configuration -> configuration.setDescription("Dependency constraints to enforce access transformer usage."));
        }
        catch (InvalidUserDataException e) {
            c = configurations.named("accessTransformerDependencyConstraints", DependencyScopeConfiguration.class);
        }
        NamedDomainObjectProvider accessTransformersDependencyConstraints = c;
        ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().forEach(sourceSet -> {
            Set<Dependency> dependencies = Util.collect(configurations, sourceSet, true, dependency -> {
                ExtraPropertiesExtension ext = ((ExtensionAware)dependency).getExtensions().getExtraProperties();
                return ext.has("__at_attribute");
            });
            dependencies.forEach(dependency -> {
                ExtraPropertiesExtension ext = ((ExtensionAware)dependency).getExtensions().getExtraProperties();
                Object dependencyNotation = dependency;
                if (dependencyNotation instanceof ProviderConvertible) {
                    dependencyNotation = ((ProviderConvertible)dependencyNotation).asProvider();
                }
                if (dependencyNotation instanceof Provider) {
                    dependencyNotation = ((Provider)dependencyNotation).get();
                }
                if (!(dependencyNotation instanceof MinimalExternalModuleDependency) && !(dependencyNotation instanceof ProjectDependency) && dependencyNotation instanceof ModuleVersionSelector) {
                    ModuleVersionSelector module = (ModuleVersionSelector)dependencyNotation;
                    dependencyNotation = module.getModule().toString();
                }
                ((DependencyScopeConfiguration)accessTransformersDependencyConstraints.get()).getDependencyConstraints().add((Object)project.getDependencies().getConstraints().create(dependencyNotation, constraint -> constraint.attributes(a -> a.attribute((Attribute)ext.get("__at_attribute"), (Object)true))));
                Util.forClasspathConfigurations(configurations, sourceSet, (Action<? super Configuration>)((Action)c -> c.extendsFrom(new Configuration[]{(Configuration)accessTransformersDependencyConstraints.get()})));
            });
        });
    }

    @Override
    public AccessTransformersContainer register(Attribute<Boolean> attribute, Action<? super AccessTransformersContainer.Options> options) {
        this.container = AccessTransformersContainer.register(this.project, attribute, options);
        return this.container;
    }

    private AccessTransformersContainer getContainer() {
        try {
            return Objects.requireNonNull(this.container);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Cannot configure options for AccessTransformers without having registered one! Use accessTransformers#register in your project.", e);
        }
    }

    @Override
    public Attribute<Boolean> getAttribute() {
        return this.getContainer().getAttribute();
    }

    @Override
    public AccessTransformersContainer.Options getOptions() {
        return this.getContainer().getOptions();
    }

    @Override
    public Dependency dep(Object dependencyNotation, @DelegatesTo(value=Dependency.class) @ClosureParams(value=SimpleType.class, options={"org.gradle.api.artifacts.Dependency"}) Closure<?> closure) {
        return this.getContainer().dep(dependencyNotation, closure);
    }

    @Override
    public Provider<?> dep(Provider<?> dependencyNotation, @DelegatesTo(value=Dependency.class) @ClosureParams(value=SimpleType.class, options={"org.gradle.api.artifacts.Dependency"}) Closure<?> closure) {
        return this.getContainer().dep(dependencyNotation, closure);
    }
}

