/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformers.gradle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersConfiguration;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersConfigurationInternal;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersContainer;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersContainerInternal;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersExtension;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersExtensionInternal;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersPlugin;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersProblems;
import net.minecraftforge.accesstransformers.gradle.ArtifactAccessTransformer;
import net.minecraftforge.accesstransformers.gradle.Util;
import net.minecraftforge.accesstransformers.gradle.shadow.net.minecraftforge.gradleutils.shared.Closures;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.Nullable;

abstract class AccessTransformersExtensionImpl
implements AccessTransformersExtensionInternal {
    private static final Logger LOGGER = Logging.getLogger(AccessTransformersExtension.class);
    private final Project project;
    private final AccessTransformersPlugin plugin;
    private final AccessTransformersProblems problems = (AccessTransformersProblems)this.getObjects().newInstance(AccessTransformersProblems.class, new Object[0]);
    @Nullable
    private AccessTransformersContainer container;

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProjectLayout getLayout();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    public AccessTransformersExtensionImpl(AccessTransformersPlugin plugin, Project project) {
        this.project = project;
        this.plugin = plugin;
        project.getConfigurations().configureEach(c -> c.withDependencies(d -> this.apply((Configuration)c)));
    }

    private void apply(Configuration configuration) {
        Set hierarchy = configuration.getHierarchy();
        Set dependencyConstraints = hierarchy.stream().flatMap(c -> c.getDependencyConstraints().matching(AccessTransformersConfigurationInternal::has).stream()).collect(Collectors.toSet());
        LinkedList projectDependencies = new LinkedList();
        LinkedHashMap moduleDependencies = new LinkedHashMap();
        hierarchy.stream().flatMap(c -> c.getDependencies().matching(AccessTransformersConfigurationInternal::has).stream()).forEach(dependency -> {
            if (dependency instanceof ProjectDependency) {
                ProjectDependency p = (ProjectDependency)dependency;
                projectDependencies.add(p);
            } else if (dependency instanceof ModuleVersionSelector) {
                ModuleVersionSelector m = (ModuleVersionSelector)dependency;
                moduleDependencies.put(m, dependency);
            } else {
                this.problems.reportIllegalTargetDependency((Dependency)dependency);
            }
        });
        for (ProjectDependency projectDependency : projectDependencies) {
            List<AccessTransformersConfigurationInternal> configs = AccessTransformersConfigurationInternal.get(projectDependency);
            ArrayList<Attribute<Boolean>> attributes = new ArrayList<Attribute<Boolean>>(configs.size());
            for (AccessTransformersConfigurationInternal config : configs) {
                attributes.add(this.register(projectDependency, config));
            }
            this.applyToProject(configuration, projectDependency.getPath(), attributes);
        }
        for (Map.Entry entry : moduleDependencies.entrySet()) {
            Dependency dependency3 = (Dependency)entry.getValue();
            ModuleVersionSelector module2 = (ModuleVersionSelector)entry.getKey();
            String moduleSelector = "%s%s".formatted(module2.getModule().toString(), module2.getVersion() != null ? ":" + module2.getVersion() : "");
            List<AccessTransformersConfigurationInternal> configs = AccessTransformersConfigurationInternal.get(dependency3);
            ArrayList<Attribute<Boolean>> attributes = new ArrayList<Attribute<Boolean>>(configs.size());
            for (AccessTransformersConfigurationInternal config : configs) {
                attributes.add(this.register(dependency3, config));
            }
            Iterator itor = dependencyConstraints.iterator();
            DependencyConstraint constraint = (DependencyConstraint)itor.next();
            while (itor.hasNext()) {
                if (Objects.equals(constraint.getModule(), module2.getModule()) && Objects.equals(constraint.getVersion(), module2.getVersion())) {
                    itor.remove();
                    List<AccessTransformersConfigurationInternal> constraintConfigs = AccessTransformersConfigurationInternal.get(constraint);
                    for (AccessTransformersConfigurationInternal config : constraintConfigs) {
                        attributes.add(this.register(constraint, config));
                    }
                }
                constraint = (DependencyConstraint)itor.next();
            }
            this.applyToDependency(configuration, dependency3, moduleSelector, attributes);
        }
        dependencyConstraints.stream().collect(Collectors.groupingBy(ModuleVersionSelector::getModule)).forEach((module, allConstraints) -> {
            String version2 = "unspecified";
            for (DependencyConstraint constraint2 : allConstraints) {
                if (constraint2.getVersion() != null) continue;
                version2 = configuration.getAllDependencies().stream().filter(dependency -> dependency.getVersion() != null && Objects.equals(dependency.getGroup(), module.getGroup()) && Objects.equals(dependency.getName(), module.getName())).map(Dependency::getVersion).max(Comparator.naturalOrder()).orElse("unspecified");
                break;
            }
            String defaultVersion = version2;
            allConstraints.stream().collect(Collectors.groupingBy(constraint -> {
                String version = constraint.getVersion();
                return version != null ? version : defaultVersion;
            })).forEach((version, constraints) -> {
                if ("unspecified".equals(version)) {
                    version = null;
                }
                List<Attribute<Boolean>> attributes = constraints.stream().flatMap(constraint -> AccessTransformersConfigurationInternal.get(constraint).stream().map(config -> this.register(constraint, (AccessTransformersConfigurationInternal)config))).toList();
                String moduleSelector = String.valueOf(module) + (String)(version != null ? ":" + version : "");
                this.applyToConstraint(configuration, (ModuleIdentifier)module, moduleSelector, (Iterable<Attribute<Boolean>>)attributes);
            });
        });
    }

    private void applyToProject(Configuration configuration, String path, Iterable<Attribute<Boolean>> attributes) {
        configuration.getResolutionStrategy().dependencySubstitution(s -> {
            ComponentSelector component = s.project(path);
            DependencySubstitutions.Substitution substitute = s.substitute(component);
            ComponentSelector variant = s.variant(component, v -> v.attributes(a -> {
                for (Attribute attribute : attributes) {
                    a.attribute(attribute, (Object)true);
                }
            }));
            substitute.using(variant);
        });
    }

    private void applyToDependency(Configuration configuration, Dependency dependency, String moduleSelector, Iterable<Attribute<Boolean>> attributes) {
        configuration.getResolutionStrategy().dependencySubstitution(s -> {
            ComponentSelector component = s.module(moduleSelector);
            DependencySubstitutions.Substitution substitute = s.substitute(component);
            ComponentSelector variant = s.variant(component, v -> v.attributes(a -> {
                for (Attribute attribute : attributes) {
                    a.attribute(attribute, (Object)true);
                }
            }));
            try {
                substitute.using(variant);
            }
            catch (InvalidUserDataException e) {
                String message = e.getMessage();
                if (message != null && StringGroovyMethods.containsIgnoreCase((CharSequence)message, (CharSequence)"must specify version")) {
                    this.problems.reportDependencyWithoutVersion(e, dependency);
                }
                throw e;
            }
        });
    }

    private void applyToConstraint(Configuration configuration, ModuleIdentifier module, String moduleSelector, Iterable<Attribute<Boolean>> attributes) {
        configuration.getResolutionStrategy().dependencySubstitution(s -> {
            ComponentSelector component = s.module(moduleSelector);
            DependencySubstitutions.Substitution substitute = s.substitute(component);
            ComponentSelector variant = s.variant(component, v -> v.attributes(a -> {
                for (Attribute attribute : attributes) {
                    a.attribute(attribute, (Object)true);
                }
            }));
            try {
                substitute.using(variant);
            }
            catch (InvalidUserDataException e) {
                String message = e.getMessage();
                if (message != null && StringGroovyMethods.containsIgnoreCase((CharSequence)message, (CharSequence)"must specify version")) {
                    this.problems.reportDependencyConstraintWithoutVersion(e, module, configuration);
                }
                throw e;
            }
        });
    }

    private Attribute<Boolean> register(Object dependency, AccessTransformersConfigurationInternal config) {
        this.validateConfigFile(dependency, config.getConfig());
        int index = this.getIndex();
        Attribute attribute = Attribute.of((String)("net.minecraftforge.accesstransformers.automatic." + index), Boolean.class);
        this.project.dependencies(Closures.consumer(this, dependencies -> {
            dependencies.attributesSchema(attributesSchema -> attributesSchema.attribute(attribute));
            dependencies.getArtifactTypes().named("jar", type -> type.getAttributes().attribute(attribute, (Object)false));
            dependencies.registerTransform(ArtifactAccessTransformer.class, spec -> {
                spec.parameters(parameters -> {
                    parameters.getConfig().set((Provider)config.getConfig());
                    parameters.getLogLevel().set(config.options().getLogLevel());
                    parameters.getClasspath().setFrom((Iterable)config.options().getClasspath());
                    parameters.getMainClass().set(config.options().getMainClass());
                    parameters.getJavaLauncher().set(config.options().getJavaLauncher().map(Util.LAUNCHER_EXECUTABLE));
                    parameters.getArgs().set(config.options().getArgs().map(Util::listToString));
                    parameters.getCachesDir().convention((Provider)this.plugin.localCaches());
                });
                this.setAttributes(spec.getFrom(), (Attribute<Boolean>)attribute, false);
                this.setAttributes(spec.getTo(), (Attribute<Boolean>)attribute, true);
            });
        }));
        return attribute;
    }

    private void setAttributes(AttributeContainer attributes, Attribute<Boolean> attribute, boolean value) {
        attributes.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar").attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.getObjects().named(Category.class, "library"))).attribute(attribute, (Object)value);
    }

    private int getIndex() {
        Gradle gradle = this.project.getGradle();
        ExtraPropertiesExtension ext = gradle.getExtensions().getExtraProperties();
        int index = ext.has("__accessTransformers_automatic_index") ? (Integer)Objects.requireNonNull(ext.get("__accessTransformers_automatic_index"), "Index ext property should never be null!") + 1 : 0;
        gradle.getExtensions().getExtraProperties().set("__accessTransformers_automatic_index", (Object)index);
        return index;
    }

    private void validateConfigFile(Object dependency, RegularFileProperty atFileProperty) {
        String atFileContents;
        RegularFile atFileSource;
        String string;
        if (dependency instanceof Dependency) {
            Dependency d = (Dependency)dependency;
            string = Util.toString(d);
        } else {
            string = dependency.toString();
        }
        String dependencyToString = string;
        try {
            atFileSource = (RegularFile)atFileProperty.get();
        }
        catch (IllegalStateException e) {
            throw this.problems.accessTransformerConfigNotDefined(new RuntimeException("Failed to resolve config file property", e), dependencyToString);
        }
        File atFile = atFileSource.getAsFile();
        String atFilePath = this.getLayout().getProjectDirectory().getAsFile().toPath().relativize(atFile.toPath()).toString();
        if (!atFile.exists()) {
            throw this.problems.accessTransformerConfigMissing(new RuntimeException(new FileNotFoundException("Config file does not exist at " + atFilePath)), dependencyToString, atFilePath);
        }
        try {
            atFileContents = (String)this.getProviders().fileContents(atFileSource).getAsText().get();
        }
        catch (Throwable e) {
            throw this.problems.accessTransformerConfigUnreadable(new RuntimeException(new IOException("Failed to read config file at " + atFilePath, e)), dependencyToString, atFilePath);
        }
        if (atFileContents.isBlank()) {
            throw this.problems.accessTransformerConfigEmpty(new IllegalStateException("Config file must not be blank at " + atFilePath), dependencyToString, atFilePath);
        }
    }

    @Override
    public AccessTransformersContainer register(Action<? super AccessTransformersContainer.Options> options) {
        this.container = AccessTransformersContainerInternal.register(this.project, options);
        return this.container;
    }

    private AccessTransformersContainer getContainer() {
        return this.container == null ? (this.container = AccessTransformersContainerInternal.register(this.project, (Action<? super AccessTransformersContainerInternal.Options>)((Action)it -> {}))) : this.container;
    }

    @Override
    public AccessTransformersContainer.Options getOptions() {
        return this.getContainer().getOptions();
    }

    @Override
    public void options(Action<? super AccessTransformersContainer.Options> action) {
        this.getContainer().options(action);
    }

    @Override
    public void configure(Object dependency) {
        this.getContainer().configure(dependency);
    }

    @Override
    public void configure(Object dependency, Action<? super AccessTransformersConfiguration> action) {
        this.getContainer().configure(dependency, action);
    }
}

