/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformers.gradle;

import javax.inject.Inject;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersConfiguration;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersConfigurationImpl;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersConfigurationInternal;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersContainer;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersContainerInternal;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersPlugin;
import net.minecraftforge.accesstransformers.gradle.Constants;
import net.minecraftforge.accesstransformers.gradle.Tools;
import net.minecraftforge.accesstransformers.gradle.Util;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaLauncher;

abstract class AccessTransformersContainerImpl
implements AccessTransformersContainerInternal {
    private final OptionsImpl options;

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    public AccessTransformersContainerImpl(Project project, Action<? super AccessTransformersContainer.Options> options) {
        this.options = (OptionsImpl)this.getObjects().newInstance(OptionsImpl.class, new Object[]{project});
        options.execute((Object)this.options);
    }

    @Override
    public AccessTransformersContainer.Options getOptions() {
        return this.options;
    }

    @Override
    public void configure(Object dependency, Action<? super AccessTransformersConfiguration> action) {
        AccessTransformersConfigurationImpl config = new AccessTransformersConfigurationImpl(this.getObjects().fileProperty().convention((Provider)this.options.config), this.options);
        action.execute((Object)config);
        AccessTransformersConfigurationInternal.get(dependency).add(config);
    }

    static abstract class OptionsImpl
    implements AccessTransformersContainerInternal.Options {
        private final Property<LogLevel> logLevel = this.getObjects().property(LogLevel.class);
        private final RegularFileProperty config = this.getObjects().fileProperty();
        private final ConfigurableFileCollection classpath = this.getObjects().fileCollection();
        private final Property<String> mainClass = this.getObjects().property(String.class);
        private final Property<JavaLauncher> javaLauncher = this.getObjects().property(JavaLauncher.class);
        private final ListProperty<Object> args = this.getObjects().listProperty(Object.class);

        @Inject
        protected abstract ObjectFactory getObjects();

        @Inject
        public OptionsImpl(Project project) {
            AccessTransformersPlugin plugin = (AccessTransformersPlugin)project.getPlugins().getPlugin(AccessTransformersPlugin.class);
            this.logLevel.convention((Object)LogLevel.INFO);
            this.classpath.from(new Object[]{plugin.getTool(Tools.ACCESSTRANSFORMERS)});
            this.javaLauncher.convention(Util.launcherFor(project, Tools.ACCESSTRANSFORMERS.getJavaVersion()));
            this.args.convention(Constants.ACCESSTRANSFORMERS_DEFAULT_ARGS);
        }

        @Override
        public RegularFileProperty getConfig() {
            return this.config;
        }

        @Override
        public Property<LogLevel> getLogLevel() {
            return this.logLevel;
        }

        @Override
        public ConfigurableFileCollection getClasspath() {
            return this.classpath;
        }

        @Override
        public Property<String> getMainClass() {
            return this.mainClass;
        }

        @Override
        public Property<JavaLauncher> getJavaLauncher() {
            return this.javaLauncher;
        }

        @Override
        public ListProperty<Object> getArgs() {
            return this.args;
        }
    }
}

