/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformers.gradle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersConfiguration;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersConfigurationImpl;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersContainer;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersContainerInternal;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersExtensionInternal;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersPlugin;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersProblems;
import net.minecraftforge.accesstransformers.gradle.ArtifactAccessTransformer;
import net.minecraftforge.accesstransformers.gradle.Util;
import net.minecraftforge.accesstransformers.gradle.shadow.net.minecraftforge.gradleutils.shared.Closures;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.Nullable;

abstract class AccessTransformersExtensionImpl
implements AccessTransformersExtensionInternal {
    private final Project project;
    private final AccessTransformersPlugin plugin;
    private final AccessTransformersProblems problems = (AccessTransformersProblems)this.getObjects().newInstance(AccessTransformersProblems.class, new Object[0]);
    @Nullable
    private AccessTransformersContainer container;

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProjectLayout getLayout();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    public AccessTransformersExtensionImpl(AccessTransformersPlugin plugin, Project project) {
        this.project = project;
        this.plugin = plugin;
        ConfigurationContainer configurations = project.getConfigurations();
        configurations.configureEach(configuration -> configuration.withDependencies(dependencies -> {
            Set hierarchy = configuration.getHierarchy();
            Map constraints = hierarchy.stream().flatMap(c -> c.getDependencyConstraints().matching(it -> ((ExtensionAware)it).getExtensions().getExtraProperties().has("__accessTransformers_configs")).stream()).collect(Collectors.toMap(ModuleVersionSelector::getModule, Function.identity()));
            for (Configuration c2 : hierarchy) {
                for (Dependency dependency : c2.getDependencies().matching(it -> ((ExtensionAware)it).getExtensions().getExtraProperties().has("__accessTransformers_configs"))) {
                    Function<DependencySubstitutions, ComponentSelector> componentSelector;
                    ModuleVersionSelector m;
                    DependencyConstraint constraint;
                    List configs = (List)((ExtensionAware)dependency).getExtensions().getExtraProperties().get("__accessTransformers_configs");
                    ArrayList<Attribute<Boolean>> attributes = new ArrayList<Attribute<Boolean>>(configs.size());
                    Iterator iterator = configs.iterator();
                    while (iterator.hasNext()) {
                        AccessTransformersConfigurationImpl config = (AccessTransformersConfigurationImpl)iterator.next();
                        attributes.add(this.register(dependency, config));
                    }
                    if (dependency instanceof ModuleVersionSelector && (constraint = (DependencyConstraint)constraints.remove((m = (ModuleVersionSelector)dependency).getModule())) != null) {
                        List constraintConfigs = (List)((ExtensionAware)constraint).getExtensions().getExtraProperties().get("__accessTransformers_configs");
                        for (AccessTransformersConfigurationImpl config : constraintConfigs) {
                            attributes.add(this.register(constraint, config));
                        }
                    }
                    if (dependency instanceof ProjectDependency) {
                        ProjectDependency p = (ProjectDependency)dependency;
                        String path = p.getPath();
                        componentSelector = s -> s.project(path);
                    } else if (dependency instanceof ModuleVersionSelector) {
                        ModuleVersionSelector m2 = (ModuleVersionSelector)dependency;
                        String module = "%s%s".formatted(m2.getModule().toString(), m2.getVersion() != null ? ":" + m2.getVersion() : "");
                        componentSelector = s -> s.module(module);
                    } else {
                        this.problems.reportIllegalTargetDependency(dependency);
                        return;
                    }
                    this.apply((Configuration)configuration, componentSelector, (Iterable<Attribute<Boolean>>)attributes);
                }
            }
            for (DependencyConstraint constraint : constraints.values()) {
                List configs = (List)((ExtensionAware)constraint).getExtensions().getExtraProperties().get("__accessTransformers_configs");
                ArrayList<Attribute<Boolean>> attributes = new ArrayList<Attribute<Boolean>>(configs.size());
                for (AccessTransformersConfigurationImpl config : configs) {
                    attributes.add(this.register(constraint, config));
                }
                String module = "%s%s".formatted(constraint.getModule().toString(), constraint.getVersion() != null ? ":" + constraint.getVersion() : "");
                this.apply((Configuration)configuration, s -> s.module(module), (Iterable<Attribute<Boolean>>)attributes);
            }
        }));
    }

    private void apply(Configuration configuration, Function<DependencySubstitutions, ComponentSelector> componentSelector, Iterable<Attribute<Boolean>> attributes) {
        configuration.getResolutionStrategy().dependencySubstitution(s -> {
            ComponentSelector component = (ComponentSelector)componentSelector.apply((DependencySubstitutions)s);
            s.substitute(component).using(s.variant(component, variant -> variant.attributes(a -> {
                for (Attribute attribute : attributes) {
                    a.attribute(attribute, (Object)true);
                }
            })));
        });
    }

    private Attribute<Boolean> register(Object dependency, AccessTransformersConfigurationImpl config) {
        this.validateATFile(dependency, config.getConfig());
        ExtraPropertiesExtension ext = this.project.getGradle().getExtensions().getExtraProperties();
        int index = ext.has("__accessTransformers_automatic_index") ? (Integer)ext.get("__accessTransformers_automatic_index") + 1 : 0;
        this.project.getGradle().getExtensions().getExtraProperties().set("__accessTransformers_automatic_index", (Object)index);
        Attribute attribute = Attribute.of((String)("net.minecraftforge.accesstransformers.automatic." + index), Boolean.class);
        this.project.dependencies(Closures.consumer(this, dependencies -> {
            dependencies.attributesSchema(attributesSchema -> {
                if (attributesSchema.hasAttribute(attribute)) {
                    throw new IllegalStateException("Another project in this build is already using this attribute for AccessTransformers: " + String.valueOf(attribute));
                }
                attributesSchema.attribute(attribute);
            });
            dependencies.getArtifactTypes().named("jar", type -> type.getAttributes().attribute(attribute, (Object)false));
            dependencies.registerTransform(ArtifactAccessTransformer.class, spec -> {
                spec.parameters(parameters -> {
                    parameters.getConfig().set((Provider)config.getConfig());
                    parameters.getLogLevel().set(config.options().getLogLevel());
                    parameters.getClasspath().setFrom((Iterable)config.options().getClasspath());
                    parameters.getMainClass().set(config.options().getMainClass());
                    parameters.getJavaLauncher().set(config.options().getJavaLauncher().map(Util.LAUNCHER_EXECUTABLE));
                    parameters.getArgs().set(config.options().getArgs().map(Util::listToString));
                    parameters.getCachesDir().convention((Provider)this.plugin.localCaches());
                });
                AccessTransformersExtensionImpl.setAttributes(spec.getFrom(), (Attribute<Boolean>)attribute, false);
                AccessTransformersExtensionImpl.setAttributes(spec.getTo(), (Attribute<Boolean>)attribute, true);
            });
        }));
        return attribute;
    }

    private static void setAttributes(AttributeContainer attributes, Attribute<Boolean> attribute, boolean value) {
        attributes.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar").attribute(attribute, (Object)value);
    }

    private void validateATFile(Object dependency, RegularFileProperty atFileProperty) {
        String atFileContents;
        RegularFile atFileSource;
        String string;
        if (dependency instanceof Dependency) {
            Dependency d = (Dependency)dependency;
            string = Util.toString(d);
        } else {
            string = dependency.toString();
        }
        String dependencyToString = string;
        try {
            atFileSource = (RegularFile)atFileProperty.get();
        }
        catch (IllegalStateException e) {
            throw this.problems.accessTransformerConfigNotDefined(new RuntimeException("Failed to resolve config file property", e), dependencyToString);
        }
        File atFile = atFileSource.getAsFile();
        String atFilePath = this.getLayout().getProjectDirectory().getAsFile().toPath().relativize(atFile.toPath()).toString();
        if (!atFile.exists()) {
            throw this.problems.accessTransformerConfigMissing(new RuntimeException(new FileNotFoundException("Config file does not exist at " + atFilePath)), dependencyToString, atFilePath);
        }
        try {
            atFileContents = (String)this.getProviders().fileContents(atFileSource).getAsText().get();
        }
        catch (Throwable e) {
            throw this.problems.accessTransformerConfigUnreadable(new RuntimeException(new IOException("Failed to read config file at " + atFilePath, e)), dependencyToString, atFilePath);
        }
        if (atFileContents.isBlank()) {
            throw this.problems.accessTransformerConfigEmpty(new IllegalStateException("Config file must not be blank at " + atFilePath), dependencyToString, atFilePath);
        }
    }

    @Override
    public AccessTransformersContainer register(Action<? super AccessTransformersContainer.Options> options) {
        this.container = AccessTransformersContainerInternal.register(this.project, options);
        return this.container;
    }

    private AccessTransformersContainer getContainer() {
        return this.container == null ? (this.container = AccessTransformersContainerInternal.register(this.project, (Action<? super AccessTransformersContainerInternal.Options>)((Action)it -> {}))) : this.container;
    }

    @Override
    public AccessTransformersContainer.Options getOptions() {
        return this.getContainer().getOptions();
    }

    @Override
    public void options(Action<? super AccessTransformersContainer.Options> action) {
        this.getContainer().options(action);
    }

    @Override
    public void configure(Object dependency, Action<? super AccessTransformersConfiguration> action) {
        this.getContainer().configure(dependency, action);
    }
}

