/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformers.gradle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersConfiguration;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersConfigurationImpl;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersContainer;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersExtensionInternal;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersPlugin;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersProblems;
import net.minecraftforge.accesstransformers.gradle.ArtifactAccessTransformer;
import net.minecraftforge.accesstransformers.gradle.Util;
import net.minecraftforge.accesstransformers.gradle.shadow.net.minecraftforge.gradleutils.shared.Closures;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyScopeConfiguration;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.Nullable;

abstract class AccessTransformersExtensionImpl
implements AccessTransformersExtensionInternal {
    private final Project project;
    private final AccessTransformersPlugin plugin;
    private final AccessTransformersProblems problems = (AccessTransformersProblems)this.getObjects().newInstance(AccessTransformersProblems.class, new Object[0]);
    private final NamedDomainObjectProvider<DependencyScopeConfiguration> constraintsConfiguration;
    @Nullable
    private AccessTransformersContainer container;

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProjectLayout getLayout();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    public AccessTransformersExtensionImpl(AccessTransformersPlugin plugin, Project project) {
        NamedDomainObjectProvider c;
        this.project = project;
        this.plugin = plugin;
        ConfigurationContainer configurations = project.getConfigurations();
        try {
            c = configurations.dependencyScope("accessTransformersDependencyConstraints", configuration -> configuration.setDescription("Dependency constraints to enforce access transformer usage."));
        }
        catch (InvalidUserDataException e) {
            c = configurations.named("accessTransformerDependencyConstraints", DependencyScopeConfiguration.class);
        }
        this.constraintsConfiguration = c;
        project.getGradle().projectsEvaluated(gradle -> this.finish(project));
    }

    private void finish(Project project) {
        ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().forEach(sourceSet -> Util.forClasspathConfigurations(project.getConfigurations(), sourceSet, (Action<? super Configuration>)((Action)c -> c.extendsFrom(new Configuration[]{(Configuration)this.constraintsConfiguration.get()}))));
        project.getConfigurations().forEach(c -> c.getDependencies().matching(it -> ((ExtensionAware)it).getExtensions().getExtraProperties().has("__accessTransformers_configs")).forEach(dependency -> {
            Object dependencyNotation = dependency;
            if (!(dependencyNotation instanceof MinimalExternalModuleDependency) && !(dependencyNotation instanceof ProjectDependency) && dependencyNotation instanceof ModuleVersionSelector) {
                ModuleVersionSelector module = (ModuleVersionSelector)dependencyNotation;
                dependencyNotation = module.getModule().toString();
            }
            List configs = (List)((ExtensionAware)dependency).getExtensions().getExtraProperties().get("__accessTransformers_configs");
            ArrayList<Attribute<Boolean>> attributes = new ArrayList<Attribute<Boolean>>(configs.size());
            for (int i = 0; i < configs.size(); ++i) {
                AccessTransformersConfigurationImpl config = (AccessTransformersConfigurationImpl)configs.get(i);
                attributes.add(this.register(i, (Dependency)dependency, config));
            }
            ((DependencyScopeConfiguration)this.constraintsConfiguration.get()).getDependencyConstraints().add((Object)this.project.getDependencies().getConstraints().create(dependencyNotation, constraint -> constraint.attributes(a -> {
                for (Attribute attribute : attributes) {
                    a.attribute(attribute, (Object)true);
                }
            })));
        }));
    }

    private Attribute<Boolean> register(int index, Dependency dependency, AccessTransformersConfigurationImpl config) {
        this.validateATFile(dependency, config.getConfig());
        Attribute attribute = Attribute.of((String)("net.minecraftforge.accesstransformers.automatic." + index), Boolean.class);
        this.project.dependencies(Closures.consumer(this, dependencies -> {
            dependencies.attributesSchema(attributesSchema -> {
                if (attributesSchema.hasAttribute(attribute)) {
                    throw new IllegalStateException("Another project in this build is already using this attribute for AccessTransformers: " + String.valueOf(attribute));
                }
                attributesSchema.attribute(attribute);
            });
            dependencies.getArtifactTypes().named("jar", type -> type.getAttributes().attribute(attribute, (Object)false));
            dependencies.registerTransform(ArtifactAccessTransformer.class, spec -> {
                spec.parameters(parameters -> {
                    parameters.getConfig().set((Provider)config.getConfig());
                    parameters.getLogLevel().set(config.options().getLogLevel());
                    parameters.getClasspath().setFrom((Iterable)config.options().getClasspath());
                    parameters.getMainClass().set(config.options().getMainClass());
                    parameters.getJavaLauncher().set(config.options().getJavaLauncher().map(Util.LAUNCHER_EXECUTABLE));
                    parameters.getArgs().set(config.options().getArgs().map(Util::listToString));
                    parameters.getCachesDir().convention((Provider)this.plugin.localCaches());
                });
                AccessTransformersExtensionImpl.setAttributes(spec.getFrom(), (Attribute<Boolean>)attribute, false);
                AccessTransformersExtensionImpl.setAttributes(spec.getTo(), (Attribute<Boolean>)attribute, true);
            });
        }));
        return attribute;
    }

    private static void setAttributes(AttributeContainer attributes, Attribute<Boolean> attribute, boolean value) {
        attributes.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar").attribute(attribute, (Object)value);
    }

    private void validateATFile(Dependency dependency, RegularFileProperty atFileProperty) {
        String atFileContents;
        RegularFile atFileSource;
        try {
            atFileSource = (RegularFile)atFileProperty.get();
        }
        catch (IllegalStateException e) {
            throw this.problems.accessTransformerConfigNotDefined(new RuntimeException("Failed to resolve config file property", e), dependency);
        }
        File atFile = atFileSource.getAsFile();
        String atFilePath = this.getLayout().getProjectDirectory().getAsFile().toPath().relativize(atFile.toPath()).toString();
        if (!atFile.exists()) {
            throw this.problems.accessTransformerConfigMissing(new RuntimeException(new FileNotFoundException("Config file does not exist at " + atFilePath)), dependency, atFilePath);
        }
        try {
            atFileContents = (String)this.getProviders().fileContents(atFileSource).getAsText().get();
        }
        catch (Throwable e) {
            throw this.problems.accessTransformerConfigUnreadable(new RuntimeException(new IOException("Failed to read config file at " + atFilePath, e)), dependency, atFilePath);
        }
        if (atFileContents.isBlank()) {
            throw this.problems.accessTransformerConfigEmpty(new IllegalStateException("Config file must not be blank at " + atFilePath), dependency, atFilePath);
        }
    }

    @Override
    public AccessTransformersContainer register(Action<? super AccessTransformersContainer.Options> options) {
        this.container = AccessTransformersContainer.register(this.project, options);
        return this.container;
    }

    private AccessTransformersContainer getContainer() {
        return this.container == null ? (this.container = AccessTransformersContainer.register(this.project, (Action<? super AccessTransformersContainer.Options>)((Action)it -> {}))) : this.container;
    }

    @Override
    public AccessTransformersContainer.Options getOptions() {
        return this.getContainer().getOptions();
    }

    @Override
    public void options(Action<? super AccessTransformersContainer.Options> action) {
        this.getContainer().options(action);
    }

    @Override
    public void configure(Dependency dependency, Action<? super AccessTransformersConfiguration> action) {
        this.getContainer().configure(dependency, action);
    }
}

