/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformers.gradle;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersPlugin;
import net.minecraftforge.accesstransformers.gradle.shadow.net.minecraftforge.util.download.DownloadUtils;
import net.minecraftforge.accesstransformers.gradle.shadow.net.minecraftforge.util.hash.HashStore;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

enum DefaultTools implements Callable<File>
{
    ACCESS_TRANSFORMERS("accesstransformers.jar", "https://maven.minecraftforge.net/net/minecraftforge/accesstransformers/8.2.2/accesstransformers-8.2.2-fatjar.jar");

    private final String fileName;
    private final String downloadUrl;
    private static @UnknownNullability DirectoryProperty caches;
    @Nullable
    private Future<File> future;

    private DefaultTools(String fileName, String downloadUrl) {
        this.fileName = fileName;
        this.downloadUrl = downloadUrl;
    }

    static void start(DirectoryProperty cachesDir) {
        if (caches != null) {
            return;
        }
        caches = cachesDir;
        for (DefaultTools tool : DefaultTools.values()) {
            tool.future = CompletableFuture.supplyAsync(tool::download);
        }
    }

    private File download() {
        File outFile = ((RegularFile)caches.file(this.fileName).get()).getAsFile();
        String name = outFile.getName();
        HashStore cache = HashStore.fromFile(outFile).add("tool", outFile).add("url", this.downloadUrl);
        if (outFile.exists() && cache.isSame()) {
            AccessTransformersPlugin.LOGGER.info("Default tool already downloaded: {}", (Object)name);
        } else {
            AccessTransformersPlugin.LOGGER.info("Downloading default tool: {}", (Object)name);
            try {
                DownloadUtils.downloadFile(outFile, this.downloadUrl);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to download default tool: " + name, e);
            }
            cache.add("tool", outFile).save();
        }
        return outFile;
    }

    @Override
    public File call() throws Exception {
        try {
            return Objects.requireNonNull(this.future, "Default tools are not initialized").get();
        }
        catch (Throwable e) {
            throw new IOException("Failed to download default tool: " + this.fileName, e);
        }
    }
}

