/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformers.gradle;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.stc.FirstParam;
import java.util.function.Consumer;
import java.util.function.Function;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.gradle.api.Action;
import org.jetbrains.annotations.UnknownNullability;

final class Closures {
    Closures() {
    }

    static <T> @UnknownNullability T invoke(Object object, @DelegatesTo(value=FirstParam.class, strategy=1) Closure closure) {
        closure.setDelegate(object);
        closure.setResolveStrategy(1);
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(closure.getClass().getClassLoader());
        try {
            Object ret = closure.getMaximumNumberOfParameters() == 0 ? closure.call() : closure.call(object);
            Object object2 = ret != null ? ret : null;
            return (T)object2;
        }
        catch (InvokerInvocationException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    static <T, R> Closure<R> function(Object owner, Function<? super T, ? extends R> function) {
        return new Functional(owner, function);
    }

    static <T> Closure<Void> action(Object owner, Action<? super T> action) {
        return Closures.consumer(owner, arg_0 -> action.execute(arg_0));
    }

    static <T> Closure<Void> consumer(Object owner, Consumer<? super T> consumer) {
        return new Consuming(owner, consumer);
    }

    static Closure<Void> empty(Object owner) {
        return new Empty(owner);
    }

    private static class Empty
    extends Closure<Void> {
        public Empty(Object owner) {
            super(owner, owner);
        }

        public Void doCall() {
            return null;
        }
    }

    private static final class Consuming<T>
    extends Closure<Void> {
        private final Consumer<? super T> consumer;

        private Consuming(Object owner, Consumer<? super T> consumer) {
            super(owner, owner);
            this.consumer = consumer;
        }

        public Void doCall(T object) {
            this.consumer.accept(object);
            return null;
        }
    }

    private static final class Functional<T, R>
    extends Closure<R> {
        private final Function<? super T, ? extends R> function;

        private Functional(Object owner, Function<? super T, ? extends R> function) {
            super(owner, owner);
            this.function = function;
        }

        public R doCall(T object) {
            return this.function.apply(object);
        }
    }
}

