/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformers.gradle;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.minecraftforge.accesstransformers.gradle.shadow.net.minecraftforge.util.hash.HashStore;
import org.apache.groovy.util.Maps;
import org.gradle.api.Action;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;

public abstract class ArtifactAccessTransformer
implements TransformAction<Parameters> {
    private static final Logger LOGGER = Logging.getLogger(ArtifactAccessTransformer.class);
    private static final Pattern ARG_INJAR = Pattern.compile("{inJar}", 16);
    private static final Pattern ARG_ATFILE = Pattern.compile("{atFile}", 16);
    private static final Pattern ARG_OUTJAR = Pattern.compile("{outJar}", 16);
    private static final Pattern ARG_LOGFILE = Pattern.compile("{logFile}", 16);
    private final ExecOperations execOperations;

    @Inject
    public ArtifactAccessTransformer(ExecOperations execOperations) {
        this.execOperations = execOperations;
    }

    @InputArtifact
    protected abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(TransformOutputs outputs) {
        Parameters parameters = (Parameters)this.getParameters();
        File inJar = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        File atFile = (File)parameters.getConfig().map(RegularFile::getAsFile).getOrNull();
        if (atFile == null) {
            LOGGER.warn("WARNING: Access transformer configuration missing or not provided, skipping transformation for {}", (Object)inJar.getName());
            outputs.file((Object)inJar);
            return;
        }
        String outJarName = inJar.getName().replace(".jar", "-at.jar");
        File outJar = this.file(outJarName);
        File logFile = this.file(outJar.getName() + ".log");
        DirectoryProperty cachesDir = parameters.getCachesDir();
        HashStore cache = new HashStore(((Directory)cachesDir.get()).getAsFile()).load(((RegularFile)cachesDir.file(outJarName + ".cache").get()).getAsFile()).add("atFile", atFile).add("inJar", inJar).add("outJar", outJar);
        if (outJar.exists() && cache.isSame()) {
            LOGGER.info("Access transformer output up-to-date, skipping transformation for {}", (Object)inJar.getName());
        } else {
            LOGGER.info("Access transformer started. Input jar: {}", (Object)inJar.getAbsolutePath());
            ExecResult result = this.execOperations.javaexec(exec -> {
                OutputStream stream = ArtifactAccessTransformer.toLog((Action<? super String>)((Action)arg_0 -> ((Logger)LOGGER).info(arg_0)));
                exec.setStandardOutput(stream);
                exec.setErrorOutput(stream);
                exec.setExecutable((String)parameters.getJavaLauncher().get());
                exec.setClasspath((FileCollection)parameters.getClasspath().get());
                ArtifactAccessTransformer.setOptional(exec.getMainClass(), parameters.getMainClass());
                Map substitutions = Maps.of((Object)ARG_INJAR, (Object)inJar.getAbsolutePath(), (Object)ARG_ATFILE, (Object)atFile.getAbsolutePath(), (Object)ARG_OUTJAR, (Object)outJar.getAbsolutePath(), (Object)ARG_LOGFILE, (Object)logFile.getAbsolutePath());
                exec.setArgs(((List)parameters.getArgs().get()).stream().map(arg -> ArtifactAccessTransformer.replace(arg, substitutions)).collect(Collectors.toList()));
            });
            try {
                result.rethrowFailure();
                result.assertNormalExitValue();
            }
            catch (Exception e) {
                LOGGER.error("The access transformer failed to apply the transformations.\nThis could potentially be caused by an invalid access transformer configuration.\nInput Jar: {}\nAccessTransformer Config: {}\n\nCheck your access transformer configuration file and ensure it is valid.", (Object)inJar, (Object)atFile);
                throw new RuntimeException("Failed to apply access transformers to " + inJar.getName(), e);
            }
            LOGGER.info("Access transformer completed. Output jar: {}", (Object)outJar.getAbsolutePath());
            cache.add("outJar", outJar).save();
        }
        Path output = outputs.file((Object)outJarName).toPath();
        try {
            Files.copy(outJar.toPath(), output, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy access transformer output to destination: " + output.toAbsolutePath(), e);
        }
    }

    private static <T> void setOptional(Property<T> to, Provider<? extends T> from) {
        if (from.isPresent()) {
            to.set(from);
        }
    }

    private static String replace(String s, Map<Pattern, String> substitutions) {
        for (Map.Entry<Pattern, String> entry : substitutions.entrySet()) {
            s = entry.getKey().matcher(s).replaceAll(Matcher.quoteReplacement(entry.getValue()));
        }
        return s;
    }

    private File file(String path) {
        return ((RegularFile)((Parameters)this.getParameters()).getCachesDir().file(path).map(file -> {
            Path p = file.getAsFile().toPath();
            try {
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create parent directrory for " + p.toAbsolutePath(), e);
            }
            return file;
        }).get()).getAsFile();
    }

    private static OutputStream toLog(final Action<? super String> logger) {
        return new OutputStream(){
            private StringBuffer buffer = new StringBuffer(512);

            @Override
            public void write(int b) {
                if (b == 13 || b == 10) {
                    if (this.buffer.length() != 0) {
                        logger.execute((Object)this.buffer.toString());
                        this.buffer = new StringBuffer(512);
                    }
                } else {
                    this.buffer.append(b);
                }
            }
        };
    }

    public static interface Parameters
    extends TransformParameters {
        @InputFiles
        public Property<FileCollection> getClasspath();

        @Optional
        @Input
        public Property<String> getMainClass();

        @Input
        public Property<String> getJavaLauncher();

        @Input
        public ListProperty<String> getArgs();

        @InputFile
        public RegularFileProperty getConfig();

        @InputDirectory
        public DirectoryProperty getCachesDir();
    }
}

