/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformers.gradle;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.inject.Inject;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersContainer;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersPlugin;
import net.minecraftforge.accesstransformers.gradle.ArtifactAccessTransformer;
import net.minecraftforge.accesstransformers.gradle.Closures;
import net.minecraftforge.accesstransformers.gradle.Constants;
import net.minecraftforge.accesstransformers.gradle.DefaultTools;
import org.gradle.api.JavaVersion;
import org.gradle.api.PathValidation;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;

final class AccessTransformersContainerImpl
implements AccessTransformersContainer {
    private final Project project;
    private final Attribute<Boolean> attribute;
    private final OptionsImpl options;

    AccessTransformersContainerImpl(Project project, Attribute<Boolean> attribute, @DelegatesTo(value=AccessTransformersContainer.Options.class, strategy=1) @ClosureParams(value=SimpleType.class, options={"net.minecraftforge.accesstransformers.gradle.AccessTransformersContainer.Options"}) Closure options) {
        this.attribute = Objects.requireNonNull(attribute);
        this.project = project;
        this.options = new OptionsImpl(this.project);
        Closures.invoke(this.options, options);
        project.afterEvaluate(this::finish);
    }

    private void finish(Project project) {
        project.dependencies(Closures.consumer(this, dependencies -> {
            dependencies.attributesSchema(attributesSchema -> {
                if (attributesSchema.hasAttribute(this.attribute)) {
                    throw new IllegalStateException("Another project in this build is already using this attribute for AccessTransformers: " + this.attribute);
                }
                attributesSchema.attribute(this.attribute);
            });
            dependencies.getArtifactTypes().named("jar", type -> type.getAttributes().attribute(this.attribute, (Object)false));
            dependencies.registerTransform(ArtifactAccessTransformer.class, spec -> {
                spec.parameters(parameters -> {
                    parameters.getClasspath().set((Object)this.options.classpath);
                    parameters.getMainClass().set((Provider)this.options.mainClass);
                    parameters.getJavaLauncher().set((Provider)this.options.javaLauncher);
                    parameters.getArgs().set((Provider)this.options.args);
                    parameters.getConfig().set((Provider)this.options.config);
                    parameters.getCachesDir().convention(project.getLayout().getBuildDirectory().dir("accesstransformers").map(dir -> {
                        Path path = dir.getAsFile().toPath();
                        try {
                            Files.createDirectories(path, new FileAttribute[0]);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to create directory: " + path.toAbsolutePath(), e);
                        }
                        return dir;
                    }));
                });
                this.setAttributes(spec.getFrom(), false);
                this.setAttributes(spec.getTo(), true);
            });
        }));
    }

    private void setAttributes(AttributeContainer attributes, boolean value) {
        attributes.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar").attribute(this.attribute, (Object)value);
    }

    @Override
    public Attribute<Boolean> getAttribute() {
        return this.attribute;
    }

    @Override
    public void options(@DelegatesTo(value=AccessTransformersContainer.Options.class, strategy=1) @ClosureParams(value=SimpleType.class, options={"net.minecraftforge.accesstransformers.gradle.AccessTransformersContainer.Options"}) Closure closure) {
        Closures.invoke(this.options, closure);
    }

    @Override
    public Dependency dep(Object dependencyNotation, @DelegatesTo(value=Dependency.class) @ClosureParams(value=SimpleType.class, options={"org.gradle.api.artifacts.Dependency"}) Closure closure) {
        Dependency dependency = this.project.getDependencies().create(dependencyNotation, closure);
        if (dependency instanceof HasConfigurableAttributes) {
            ((HasConfigurableAttributes)dependency).attributes(a -> a.attribute(this.attribute, (Object)true));
        } else {
            AccessTransformersPlugin.LOGGER.warn("Cannot apply access transformer attribute to dependency: {} ({})", (Object)dependency, (Object)dependency.getClass().getName());
        }
        return dependency;
    }

    private static final class OptionsImpl
    implements AccessTransformersContainer.Options {
        private final Project project;
        private final ProviderFactory providers;
        @InputFiles
        private FileCollection classpath;
        @Optional
        @Input
        private final Property<String> mainClass;
        @Input
        private final Property<String> javaLauncher;
        @Input
        private final ListProperty<String> args;
        @InputFile
        private final RegularFileProperty config;

        @Inject
        public OptionsImpl(Project project) {
            this.project = project;
            ObjectFactory objects = project.getObjects();
            this.providers = project.getProviders();
            this.classpath = objects.fileCollection().from(new Object[]{DefaultTools.ACCESS_TRANSFORMERS});
            this.mainClass = objects.property(String.class);
            this.javaLauncher = objects.property(String.class).convention(this.defaultJavaLauncher());
            this.args = objects.listProperty(String.class).convention(Constants.AT_DEFAULT_ARGS);
            this.config = objects.fileProperty();
        }

        @Override
        public void setClasspath(FileCollection files) {
            this.classpath = files;
        }

        @Override
        public void setClasspath(@DelegatesTo(value=DependencyHandler.class, strategy=1) @ClosureParams(value=SimpleType.class, options={"org.gradle.api.artifacts.dsl.DependencyHandler"}) Closure<? extends Dependency> closure) {
            this.classpath = this.project.getConfigurations().detachedConfiguration(new Dependency[0]).withDependencies(dependencies -> dependencies.addLater(this.providers.provider(() -> ((Dependency)Closures.invoke(this.project.getDependencies(), closure)).copy())));
        }

        @Override
        public void setMainClass(Provider<String> mainClass) {
            this.mainClass.set(mainClass);
        }

        @Override
        public void setMainClass(String mainClass) {
            this.mainClass.set((Object)mainClass);
        }

        private Provider<String> defaultJavaLauncher() {
            return this.providers.provider(() -> {
                JavaPluginExtension java = (JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class);
                JavaToolchainService javaToolchains = (JavaToolchainService)this.project.getExtensions().getByType(JavaToolchainService.class);
                JavaLanguageVersion version = JavaLanguageVersion.of((int)8);
                JavaToolchainSpec currentToolchain = java.getToolchain();
                Provider launcher = ((JavaLanguageVersion)currentToolchain.getLanguageVersion().getOrElse((Object)JavaLanguageVersion.of((int)(JavaVersion.current().ordinal() + 1)))).canCompileOrRun(version) ? javaToolchains.launcherFor(currentToolchain) : javaToolchains.launcherFor(spec -> spec.getLanguageVersion().set((Object)version));
                return (String)launcher.map(l -> l.getExecutablePath().toString()).get();
            });
        }

        @Override
        public void setJavaLauncher(Provider<? extends JavaLauncher> javaLauncher) {
            this.javaLauncher.set(javaLauncher.map(java -> java.getExecutablePath().toString()));
        }

        @Override
        public void setJavaLauncher(JavaLauncher javaLauncher) {
            this.javaLauncher.set((Object)javaLauncher.getExecutablePath().toString());
        }

        @Override
        public void setArgs(Iterable<String> args) {
            this.args.set(args);
        }

        @Override
        public void setArgs(Provider<? extends Iterable<String>> args) {
            this.args.set(args);
        }

        @Override
        public void setConfig(Provider<?> configFile) {
            this.config.fileProvider(this.providers.provider(() -> {
                Object value = configFile.getOrNull();
                if (value == null) {
                    return null;
                }
                if (value instanceof FileSystemLocation) {
                    value = ((FileSystemLocation)value).getAsFile();
                }
                return this.project.file(value, PathValidation.FILE);
            }));
        }

        @Override
        public void setConfig(RegularFile configFile) {
            this.config.set((Object)configFile);
        }

        @Override
        public void setConfig(File configFile) {
            this.config.set(configFile);
        }

        @Override
        public void setConfig(Object configFile) {
            this.config.fileProvider(this.providers.provider(() -> this.project.file(configFile, PathValidation.FILE)));
        }
    }
}

