/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformers.gradle;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersExtension;
import net.minecraftforge.accesstransformers.gradle.AccessTransformersExtensionImpl;
import net.minecraftforge.accesstransformers.gradle.DefaultTools;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;

abstract class AccessTransformersPlugin
implements Plugin<Project> {
    static final Logger LOGGER = Logging.getLogger(AccessTransformersPlugin.class);
    private final ObjectFactory objects;
    private final ProviderFactory providers;

    @Inject
    public AccessTransformersPlugin(ObjectFactory objects, ProviderFactory providers) {
        this.objects = objects;
        this.providers = providers;
    }

    public void apply(Project project) {
        DirectoryProperty globalCaches = this.objects.directoryProperty().fileProvider(this.providers.provider(() -> {
            File dir = new File(project.getGradle().getGradleUserHomeDir(), "caches/minecraftforge/accesstransformers");
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            return dir;
        }));
        DefaultTools.start(globalCaches);
        project.getExtensions().add(AccessTransformersExtension.class, "accessTransformers", (Object)new AccessTransformersExtensionImpl(project));
    }
}

