/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.util;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.ModuleLayerHandler;
import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.TransformationServiceDecorator;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraftforge.securemodules.SecureModuleFinder;
import net.minecraftforge.srg2source.ConsoleTool;
import net.minecraftforge.srg2source.asm.TransformationService;

public class TransformingUtil {
    public static ClassLoader createTransformer() {
        TransformStore transformStore = new TransformStore();
        TransformationServiceDecorator sd = TransformingUtil.ctr(TransformingUtil.c(TransformationServiceDecorator.class, ITransformationService.class), new TransformationService());
        sd.gatherTransformers(transformStore);
        ModuleLayerHandler layerHandler = TransformingUtil.ctr(TransformingUtil.c(ModuleLayerHandler.class, new Class[0]), new Object[0]);
        LaunchPluginHandler lph = new LaunchPluginHandler(layerHandler);
        Environment environment = TransformingUtil.ctr(TransformingUtil.c(Environment.class, Launcher.class), new Object[]{null});
        new TypesafeMap(IEnvironment.class);
        ArrayList<Path> paths = new ArrayList<Path>();
        Path test = TransformingUtil.getRoot("test.marker");
        if (test != null) {
            paths.add(test);
            List<Path> classpath = TransformingUtil.getRoots("META-INF/MANIFEST.MF");
            Path eclipse = TransformingUtil.getClassRoot("org/eclipse/jdt/core/dom/CompilationUnitResolver");
            HashMap<Path, Set<String>> jars = new HashMap<Path, Set<String>>();
            for (Path path : classpath) {
                if (Files.isDirectory(path, new LinkOption[0]) || path.equals(eclipse) || path.equals(test)) continue;
                jars.put(path, TransformingUtil.gatherPackages(path));
            }
            paths.add(eclipse);
            Set<String> seen = TransformingUtil.gatherPackages(eclipse);
            ArrayDeque<String> queue = new ArrayDeque<String>(seen);
            while (!queue.isEmpty() && !jars.isEmpty()) {
                String pkg = queue.pop();
                Iterator itr = jars.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    if (!((Set)entry.getValue()).contains(pkg)) continue;
                    itr.remove();
                    paths.add((Path)entry.getKey());
                    for (String npkg : (Set)entry.getValue()) {
                        if (!seen.add(npkg)) continue;
                        queue.add(npkg);
                    }
                }
            }
        }
        paths.add(TransformingUtil.getClassRoot(ConsoleTool.class.getName()));
        SecureModuleFinder finder = SecureModuleFinder.of((SecureJar[])new SecureJar[]{SecureJar.from((Path[])((Path[])paths.toArray(Path[]::new)))});
        Configuration configuration = ModuleLayer.boot().configuration().resolveAndBind((ModuleFinder)finder, ModuleFinder.ofSystem(), Set.of("net.minecraftforge.srg2source"));
        return (ClassLoader)TransformingUtil.ctr(TransformingUtil.c(TransformingClassLoader.class, String.class, ClassLoader.class, Configuration.class, List.class, List.class, TransformStore.class, LaunchPluginHandler.class, Environment.class), "TRANSFORMER", TransformingUtil.class.getClassLoader(), configuration, List.of(ModuleLayer.boot()), List.of(), transformStore, lph, environment);
    }

    private static <T> Constructor<T> c(Class<T> cls, Class<?> ... args) {
        try {
            return cls.getDeclaredConstructor(args);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return (Constructor)TransformingUtil.sneak(e);
        }
    }

    private static <T> T ctr(Constructor<T> ctr, Object ... args) {
        ctr.setAccessible(true);
        try {
            return ctr.newInstance(args);
        }
        catch (Exception e) {
            return (T)TransformingUtil.sneak(e);
        }
    }

    private static <E extends Throwable, R> R sneak(Throwable e) throws E {
        throw e;
    }

    private static Path getClassRoot(String cls) {
        return TransformingUtil.getRoot(cls.replace('.', '/') + ".class");
    }

    private static Path getRoot(String resource) {
        return TransformingUtil.toPath(resource, ConsoleTool.class.getResource("/" + resource));
    }

    private static List<Path> getRoots(String resource) {
        return ConsoleTool.class.getClassLoader().resources(resource).map(url -> TransformingUtil.toPath(resource, url)).filter(n -> n != null).toList();
    }

    private static Path toPath(String resource, URL url) {
        if (url == null) {
            return null;
        }
        String path = url.toString().substring(0, url.toString().length() - resource.length());
        if ("jar".equals(url.getProtocol()) && path.endsWith("!/")) {
            path = path.substring(4, path.length() - 2);
        }
        if (path.startsWith("file:")) {
            path = path.substring(6);
        }
        return Paths.get(path, new String[0]);
    }

    private static Set<String> gatherPackages(Path path) {
        HashSet<String> ret = new HashSet<String>();
        try (InputStream fis = Files.newInputStream(path, new OpenOption[0]);
             ZipInputStream zip = new ZipInputStream(fis);){
            ZipEntry entry = null;
            while ((entry = zip.getNextEntry()) != null) {
                String file = entry.getName();
                if (entry.isDirectory() || file.startsWith("META-INF")) continue;
                int idx = file.lastIndexOf(47);
                if (!file.endsWith(".class") || idx == -1) continue;
                ret.add(file.substring(0, idx).replace('/', '.'));
            }
        }
        catch (IOException e) {
            return (Set)TransformingUtil.sneak(e);
        }
        return ret;
    }
}

