/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.mixin;

import net.minecraftforge.srg2source.extract.MixinProcessor;
import net.minecraftforge.srg2source.mixin.AnnotationBase;
import net.minecraftforge.srg2source.mixin.MixinAnnotation;
import net.minecraftforge.srg2source.mixin.MixinInfo;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.jetbrains.annotations.Nullable;

public class Interface
extends AnnotationBase {
    public Interface(MixinProcessor processor) {
        super(processor, MixinAnnotation.INTERFACE);
    }

    @Override
    public boolean process(NormalAnnotation node) {
        ITypeBinding parent = this.findParent(node.getParent());
        if (parent == null) {
            return this.error((ASTNode)node, "Could not resolve owner for @Interface annotation: " + node.toString());
        }
        String prefix = null;
        Type iface = null;
        block11: for (MemberValuePair mvp : node.values()) {
            switch (mvp.getName().toString()) {
                case "unique": 
                case "remap": {
                    continue block11;
                }
                case "prefix": {
                    if (mvp.getValue().getNodeType() == 45) {
                        prefix = ((StringLiteral)mvp.getValue()).getLiteralValue();
                        continue block11;
                    }
                    return this.error((ASTNode)node, "Could not determine prefix value for @Interface annotation: " + node.toString());
                }
                case "iface": {
                    if (mvp.getValue().getNodeType() == 57) {
                        iface = ((TypeLiteral)mvp.getValue()).getType();
                        continue block11;
                    }
                    return this.error((ASTNode)node, "Could not determine prefix value for @Interface annotation: " + node.toString());
                }
            }
            return this.error((ASTNode)node, "Unknown value entry in @Interface annotation: " + node.toString());
        }
        if (prefix == null || iface == null) {
            return this.error((ASTNode)node, "Could not determine prefix/iface for @Interface annotation: " + node.toString());
        }
        MixinInfo info = this.processor.getOrCreateInfo(parent);
        info.addInterface(prefix, iface);
        return true;
    }

    @Nullable
    private ITypeBinding findParent(ASTNode parent) {
        int type = parent.getNodeType();
        if (type == 79 || type == 77 || type == 4) {
            return this.findParent(parent.getParent());
        }
        if (parent instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)parent).resolveBinding();
        }
        return null;
    }
}

