/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.extract;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.jetbrains.annotations.Nullable;

public class ExtractUtil {
    private static final String PRIMITIVE_TYPES = "ZCBSIJFDV";

    public static String getInternalName(ITypeBinding binding) {
        return ExtractUtil.getInternalName("{unknown}", binding, null);
    }

    public static String getInternalName(String filename, ITypeBinding binding, @Nullable ASTNode node) {
        String name = binding.getErasure().getBinaryName();
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Could not get Binary name! " + filename + (String)(node == null ? "" : " @ " + node.getStartPosition()));
        }
        return name.replace('.', '/');
    }

    public static String getDescriptor(IMethodBinding method) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        if (method.isConstructor()) {
            ITypeBinding type = method.getDeclaringClass();
            if (type.isEnum()) {
                buf.append("Ljava/lang/String;I");
            } else if (type.isNested() && type.isClass() && (type.getModifiers() & 8) == 0) {
                buf.append(ExtractUtil.getTypeSignature(type.getDeclaringClass()));
            }
        }
        for (ITypeBinding param : method.getParameterTypes()) {
            buf.append(ExtractUtil.getTypeSignature(param));
        }
        buf.append(')');
        buf.append(ExtractUtil.getTypeSignature(method.getReturnType()));
        return buf.toString();
    }

    public static String getDescriptor(List<SingleVariableDeclaration> params) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        for (SingleVariableDeclaration var : params) {
            ITypeBinding bind = var.getType().resolveBinding();
            if (var.isVarargs()) {
                bind = bind.createArrayType(1);
            }
            buf.append(ExtractUtil.getTypeSignature(bind));
        }
        buf.append(')');
        return buf.toString();
    }

    public static String getTypeSignature(ITypeBinding type) {
        Object ret = type.getErasure().getBinaryName().replace('.', '/');
        int aidx = ((String)ret).lastIndexOf(91);
        String prefix = null;
        if (aidx != -1) {
            prefix = ((String)ret).substring(0, aidx + 1);
            ret = ((String)ret).substring(aidx + 1);
        }
        if (!(PRIMITIVE_TYPES.contains((CharSequence)ret) || ((String)ret).charAt(0) == 'L' && ((String)ret).charAt(((String)ret).length() - 1) == ';')) {
            ret = "L" + (String)ret + ";";
        }
        return prefix == null ? ret : prefix + (String)ret;
    }

    @Nullable
    public static IMethodBinding findRoot(ITypeBinding type, String name, String desc) {
        for (IMethodBinding bind : type.getDeclaredMethods()) {
            if (!bind.getName().equals(name) || !ExtractUtil.getDescriptor(bind).equals(desc)) continue;
            return ExtractUtil.findRoot(bind);
        }
        IMethodBinding root = ExtractUtil.findRoot(type.getSuperclass(), name, desc);
        if (root != null) {
            return root;
        }
        for (ITypeBinding intf : type.getInterfaces()) {
            root = ExtractUtil.findRoot(intf, name, desc);
            if (root == null) continue;
            return root;
        }
        return null;
    }

    public static IMethodBinding findRoot(IMethodBinding mtd) {
        ITypeBinding clazz = mtd.getDeclaringClass();
        if (clazz == null) {
            return mtd;
        }
        IMethodBinding root = ExtractUtil.findRoot(mtd, clazz.getSuperclass());
        if (root != null) {
            return root.getMethodDeclaration();
        }
        for (ITypeBinding intf : clazz.getInterfaces()) {
            root = ExtractUtil.findRoot(mtd, intf);
            if (root == null) continue;
            return root.getMethodDeclaration();
        }
        return mtd;
    }

    @Nullable
    private static IMethodBinding findRoot(IMethodBinding target, @Nullable ITypeBinding type) {
        if (type == null) {
            return null;
        }
        if (target.isConstructor()) {
            return target;
        }
        for (IMethodBinding mtd : type.getDeclaredMethods()) {
            if (!target.overrides(mtd)) continue;
            return ExtractUtil.findRoot(mtd);
        }
        IMethodBinding root = ExtractUtil.findRoot(target, type.getSuperclass());
        if (root != null) {
            return root;
        }
        for (ITypeBinding intf : type.getInterfaces()) {
            root = ExtractUtil.findRoot(target, intf);
            if (root == null) continue;
            return root;
        }
        return null;
    }
}

