/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.asm;

import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.util.Collections;
import java.util.Set;
import net.minecraftforge.srg2source.extract.RangeExtractor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class CompilationUnitResolverTransfomer
implements ITransformer<ClassNode> {
    private static final String RESOLVE_METHOD = "resolve([Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;Lorg/eclipse/jdt/core/dom/FileASTRequestor;ILjava/util/Map;I)V";
    private static final String GET_CONTENTS = "org/eclipse/jdt/internal/compiler/util/Util.getFileCharContent(Ljava/io/File;Ljava/lang/String;)[C";
    private static final String HOOK_OWNER = Type.getInternalName(RangeExtractor.class);
    private static final String HOOK_DESC = Type.getMethodDescriptor((Type)Type.getType(char[].class), (Type[])new Type[]{Type.getType(String.class), Type.getType(String.class)});

    public ClassNode transform(ClassNode input, ITransformerVotingContext context) {
        System.out.println("Tansforming: " + input.name);
        MethodNode resolve = input.methods.stream().filter(e -> RESOLVE_METHOD.equals(e.name + e.desc)).findFirst().orElse(null);
        if (resolve == null) {
            throw new IllegalStateException("Could not find resolve target on " + input.name + " JDT Mismatch?: resolve([Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;Lorg/eclipse/jdt/core/dom/FileASTRequestor;ILjava/util/Map;I)V");
        }
        for (int x = 0; x < resolve.instructions.size(); ++x) {
            if (resolve.instructions.get(x).getType() != 5) continue;
            MethodInsnNode mtd = (MethodInsnNode)resolve.instructions.get(x);
            if (!GET_CONTENTS.equals(mtd.owner + "." + mtd.name + mtd.desc)) continue;
            if (resolve.instructions.get(x - 5).getOpcode() == 187 && resolve.instructions.get(x - 4).getOpcode() == 89 && resolve.instructions.get(x - 3).getOpcode() == 25 && resolve.instructions.get(x - 2).getOpcode() == 183 && resolve.instructions.get(x - 1).getOpcode() == 25) {
                resolve.instructions.set(resolve.instructions.get(x - 5), (AbstractInsnNode)new InsnNode(0));
                resolve.instructions.set(resolve.instructions.get(x - 4), (AbstractInsnNode)new InsnNode(0));
                resolve.instructions.set(resolve.instructions.get(x - 2), (AbstractInsnNode)new InsnNode(0));
                mtd.owner = HOOK_OWNER;
                mtd.desc = HOOK_DESC;
                System.out.println("Patched " + input.name);
                continue;
            }
            throw new IllegalStateException("Found Util.getFileCharContents call, with unexpected context");
        }
        return input;
    }

    public TransformerVoteResult castVote(ITransformerVotingContext context) {
        return TransformerVoteResult.YES;
    }

    public Set<ITransformer.Target> targets() {
        return Collections.singleton(ITransformer.Target.targetClass((String)"org.eclipse.jdt.core.dom.CompilationUnitResolver"));
    }
}

